/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.OperatorInformation;
import org.apache.flink.api.common.operators.util.UserCodeClassWrapper;
import org.apache.flink.api.common.operators.util.UserCodeObjectWrapper;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.util.Visitor;

public class GenericDataSourceBase<OUT, T extends InputFormat<OUT, ?>>
extends Operator<OUT> {
    private static final String DEFAULT_NAME = "<Unnamed Generic Data Source>";
    protected final UserCodeWrapper<? extends T> formatWrapper;
    protected String statisticsKey;

    public GenericDataSourceBase(T format, OperatorInformation<OUT> operatorInfo, String name) {
        super(operatorInfo, name);
        if (format == null) {
            throw new IllegalArgumentException("Input format may not be null.");
        }
        this.formatWrapper = new UserCodeObjectWrapper<T>(format);
    }

    public GenericDataSourceBase(T format, OperatorInformation<OUT> operatorInfo) {
        super(operatorInfo, DEFAULT_NAME);
        if (format == null) {
            throw new IllegalArgumentException("Input format may not be null.");
        }
        this.formatWrapper = new UserCodeObjectWrapper<T>(format);
    }

    public GenericDataSourceBase(Class<? extends T> format, OperatorInformation<OUT> operatorInfo, String name) {
        super(operatorInfo, name);
        if (format == null) {
            throw new IllegalArgumentException("Input format may not be null.");
        }
        this.formatWrapper = new UserCodeClassWrapper<T>(format);
    }

    public GenericDataSourceBase(Class<? extends T> format, OperatorInformation<OUT> operatorInfo) {
        super(operatorInfo, DEFAULT_NAME);
        if (format == null) {
            throw new IllegalArgumentException("Input format may not be null.");
        }
        this.formatWrapper = new UserCodeClassWrapper<T>(format);
    }

    public UserCodeWrapper<? extends T> getFormatWrapper() {
        return this.formatWrapper;
    }

    @Override
    public UserCodeWrapper<? extends T> getUserCodeWrapper() {
        return this.formatWrapper;
    }

    public String getStatisticsKey() {
        return this.statisticsKey;
    }

    public void setStatisticsKey(String statisticsKey) {
        this.statisticsKey = statisticsKey;
    }

    @Override
    public void accept(Visitor<Operator<?>> visitor) {
        if (visitor.preVisit(this)) {
            visitor.postVisit(this);
        }
    }

    protected List<OUT> executeOnCollections(boolean mutableObjectSafe) throws Exception {
        InputFormat inputFormat = (InputFormat)this.formatWrapper.getUserCodeObject();
        inputFormat.configure(this.parameters);
        ArrayList result = new ArrayList();
        InputSplit[] splits = inputFormat.createInputSplits(1);
        TypeSerializer serializer = this.getOperatorInfo().getOutputType().createSerializer();
        for (InputSplit split : splits) {
            inputFormat.open(split);
            while (!inputFormat.reachedEnd()) {
                Object next = inputFormat.nextRecord(serializer.createInstance());
                if (next == null) continue;
                result.add(mutableObjectSafe ? serializer.copy(next) : next);
            }
            inputFormat.close();
        }
        return result;
    }

    @Override
    public String toString() {
        return this.name;
    }
}

