/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.base;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.aggregators.Aggregator;
import org.apache.flink.api.common.aggregators.AggregatorRegistry;
import org.apache.flink.api.common.aggregators.ConvergenceCriterion;
import org.apache.flink.api.common.functions.AbstractRichFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.operators.IterationOperator;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.OperatorInformation;
import org.apache.flink.api.common.operators.SingleInputOperator;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.FlatMapOperatorBase;
import org.apache.flink.api.common.operators.util.UserCodeClassWrapper;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.types.LongValue;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkIterationBase<T>
extends SingleInputOperator<T, T, AbstractRichFunction>
implements IterationOperator {
    private static String DEFAULT_NAME = "<Unnamed Bulk Iteration>";
    public static final String TERMINATION_CRITERION_AGGREGATOR_NAME = "terminationCriterion.aggregator";
    private Operator<T> iterationResult;
    private final Operator<T> inputPlaceHolder;
    private final AggregatorRegistry aggregators = new AggregatorRegistry();
    private int numberOfIterations = -1;
    protected Operator<?> terminationCriterion;

    public BulkIterationBase(UnaryOperatorInformation<T, T> operatorInfo) {
        this(operatorInfo, DEFAULT_NAME);
    }

    public BulkIterationBase(UnaryOperatorInformation<T, T> operatorInfo, String name) {
        super(new UserCodeClassWrapper<AbstractRichFunction>(AbstractRichFunction.class), operatorInfo, name);
        this.inputPlaceHolder = new PartialSolutionPlaceHolder<T>(this, this.getOperatorInfo());
    }

    public Operator<T> getPartialSolution() {
        return this.inputPlaceHolder;
    }

    public void setNextPartialSolution(Operator<T> result) {
        if (result == null) {
            throw new NullPointerException("Operator producing the next partial solution must not be null.");
        }
        this.iterationResult = result;
    }

    public Operator<T> getNextPartialSolution() {
        return this.iterationResult;
    }

    public Operator<?> getTerminationCriterion() {
        return this.terminationCriterion;
    }

    public <X> void setTerminationCriterion(Operator<X> criterion) {
        TypeInformation<X> type = criterion.getOperatorInfo().getOutputType();
        FlatMapOperatorBase mapper = new FlatMapOperatorBase(new TerminationCriterionMapper(), new UnaryOperatorInformation<X, X>(type, type), "Termination Criterion Aggregation Wrapper");
        mapper.setInput(criterion);
        this.terminationCriterion = mapper;
        this.getAggregators().registerAggregationConvergenceCriterion(TERMINATION_CRITERION_AGGREGATOR_NAME, new TerminationCriterionAggregator(), new TerminationCriterionAggregationConvergence());
    }

    public void setMaximumNumberOfIterations(int num) {
        if (num < 1) {
            throw new IllegalArgumentException("The number of iterations must be at least one.");
        }
        this.numberOfIterations = num;
    }

    public int getMaximumNumberOfIterations() {
        return this.numberOfIterations;
    }

    @Override
    public AggregatorRegistry getAggregators() {
        return this.aggregators;
    }

    public void validate() throws InvalidProgramException {
        if (this.input == null) {
            throw new RuntimeException("Operator for initial partial solution is not set.");
        }
        if (this.iterationResult == null) {
            throw new InvalidProgramException("Operator producing the next version of the partial solution (iteration result) is not set.");
        }
        if (this.terminationCriterion == null && this.numberOfIterations <= 0) {
            throw new InvalidProgramException("No termination condition is set (neither fix number of iteration nor termination criterion).");
        }
    }

    @Override
    public Map<String, Operator<?>> getBroadcastInputs() {
        return Collections.emptyMap();
    }

    @Override
    public void setBroadcastVariable(String name, Operator<?> root) {
        throw new UnsupportedOperationException("The BulkIteration meta operator cannot have broadcast inputs.");
    }

    @Override
    public <X> void setBroadcastVariables(Map<String, Operator<X>> inputs) {
        throw new UnsupportedOperationException("The BulkIteration meta operator cannot have broadcast inputs.");
    }

    @Override
    protected List<T> executeOnCollections(List<T> inputData, RuntimeContext runtimeContext, boolean mutableObjectSafeMode) {
        throw new UnsupportedOperationException();
    }

    public static class TerminationCriterionAggregationConvergence
    implements ConvergenceCriterion<LongValue> {
        private static final long serialVersionUID = 1L;
        private static final Logger log = LoggerFactory.getLogger(TerminationCriterionAggregationConvergence.class);

        @Override
        public boolean isConverged(int iteration, LongValue countAggregate) {
            long count = countAggregate.getValue();
            if (log.isInfoEnabled()) {
                log.info("Termination criterion stats in iteration [" + iteration + "]: " + count);
            }
            return count == 0L;
        }
    }

    public static class TerminationCriterionAggregator
    implements Aggregator<LongValue> {
        private long count;

        @Override
        public LongValue getAggregate() {
            return new LongValue(this.count);
        }

        @Override
        public void aggregate(long count) {
            this.count += count;
        }

        @Override
        public void aggregate(LongValue count) {
            this.count += count.getValue();
        }

        @Override
        public void reset() {
            this.count = 0L;
        }
    }

    public static class TerminationCriterionMapper<X>
    extends AbstractRichFunction
    implements FlatMapFunction<X, X> {
        private static final long serialVersionUID = 1L;
        private TerminationCriterionAggregator aggregator;

        @Override
        public void open(Configuration parameters) {
            this.aggregator = (TerminationCriterionAggregator)this.getIterationRuntimeContext().getIterationAggregator(BulkIterationBase.TERMINATION_CRITERION_AGGREGATOR_NAME);
        }

        @Override
        public void flatMap(X in, Collector<X> out) {
            this.aggregator.aggregate(1L);
        }
    }

    public static class PartialSolutionPlaceHolder<OT>
    extends Operator<OT> {
        private final BulkIterationBase<OT> containingIteration;

        public PartialSolutionPlaceHolder(BulkIterationBase<OT> container, OperatorInformation<OT> operatorInfo) {
            super(operatorInfo, "Partial Solution");
            this.containingIteration = container;
        }

        public BulkIterationBase<OT> getContainingBulkIteration() {
            return this.containingIteration;
        }

        @Override
        public void accept(Visitor<Operator<?>> visitor) {
            visitor.preVisit(this);
            visitor.postVisit(this);
        }

        @Override
        public UserCodeWrapper<?> getUserCodeWrapper() {
            return null;
        }
    }
}

