/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.base;

import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.operators.GenericDataSourceBase;
import org.apache.flink.api.common.operators.OperatorInformation;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

public class FileDataSourceBase<OUT>
extends GenericDataSourceBase<OUT, FileInputFormat<OUT>> {
    protected final String filePath;

    public FileDataSourceBase(FileInputFormat<OUT> f, OperatorInformation<OUT> operatorInfo, String filePath, String name) {
        super(f, operatorInfo, name);
        Preconditions.checkNotNull((Object)filePath, (Object)"The file path may not be null.");
        this.filePath = filePath;
        f.setFilePath(filePath);
    }

    public FileDataSourceBase(FileInputFormat<OUT> f, OperatorInformation<OUT> operatorInfo, String filePath) {
        this(f, operatorInfo, (String)Preconditions.checkNotNull((Object)filePath, (Object)"The file path may not be null."), "File " + filePath);
    }

    public FileDataSourceBase(Class<? extends FileInputFormat<OUT>> f, OperatorInformation<OUT> operatorInfo, String filePath, String name) {
        super(f, operatorInfo, name);
        Preconditions.checkNotNull((Object)filePath, (Object)"The file path may not be null.");
        this.filePath = filePath;
        FileInputFormat.configureFileFormat(this).filePath(filePath);
    }

    public FileDataSourceBase(Class<? extends FileInputFormat<OUT>> f, OperatorInformation<OUT> operatorInfo, String filePath) {
        this(f, operatorInfo, (String)Preconditions.checkNotNull((Object)filePath, (Object)"The file path may not be null."), "File " + filePath);
    }

    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public String toString() {
        return this.filePath;
    }
}

