/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.util;

import org.apache.commons.collections.map.AbstractHashedMap;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;

public class JoinHashMap<BT>
extends AbstractHashedMap {
    private final TypeSerializer<BT> buildSerializer;
    private final TypeComparator<BT> buildComparator;

    public JoinHashMap(TypeSerializer<BT> buildSerializer, TypeComparator<BT> buildComparator) {
        super(64);
        this.buildSerializer = buildSerializer;
        this.buildComparator = buildComparator;
    }

    public TypeSerializer<BT> getBuildSerializer() {
        return this.buildSerializer;
    }

    public TypeComparator<BT> getBuildComparator() {
        return this.buildComparator;
    }

    public <PT> Prober<PT> createProber(TypeComparator<PT> probeComparator, TypePairComparator<PT, BT> pairComparator) {
        return new Prober<PT>(probeComparator, pairComparator);
    }

    public void insertOrReplace(BT record) {
        int hashCode = this.hash(this.buildComparator.hash(record));
        int index = this.hashIndex(hashCode, this.data.length);
        this.buildComparator.setReference(record);
        AbstractHashedMap.HashEntry entry = this.data[index];
        while (entry != null) {
            if (this.entryHashCode(entry) == hashCode && this.buildComparator.equalToReference(entry.getValue())) {
                entry.setValue(record);
                return;
            }
            entry = this.entryNext(entry);
        }
        this.addMapping(index, hashCode, null, record);
    }

    public class Prober<PT> {
        private final TypeComparator<PT> probeComparator;
        private final TypePairComparator<PT, BT> pairComparator;

        public Prober(TypeComparator<PT> probeComparator, TypePairComparator<PT, BT> pairComparator) {
            this.probeComparator = probeComparator;
            this.pairComparator = pairComparator;
        }

        public BT lookupMatch(PT record) {
            int hashCode = JoinHashMap.this.hash(this.probeComparator.hash(record));
            int index = JoinHashMap.this.hashIndex(hashCode, JoinHashMap.this.data.length);
            this.pairComparator.setReference(record);
            AbstractHashedMap.HashEntry entry = JoinHashMap.this.data[index];
            while (entry != null) {
                if (JoinHashMap.this.entryHashCode(entry) == hashCode && this.pairComparator.equalToReference(entry.getValue())) {
                    return entry.getValue();
                }
                entry = JoinHashMap.this.entryNext(entry);
            }
            return null;
        }
    }
}

