/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.util;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.functions.CrossFunction;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.GenericCollectorMap;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.DualInputOperator;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.GenericDataSourceBase;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.SingleInputOperator;
import org.apache.flink.api.common.operators.base.CoGroupOperatorBase;
import org.apache.flink.api.common.operators.base.CollectorMapOperatorBase;
import org.apache.flink.api.common.operators.base.CrossOperatorBase;
import org.apache.flink.api.common.operators.base.GroupReduceOperatorBase;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;

public class OperatorUtil {
    private static final Map<Class<?>, Class<? extends Operator>> STUB_CONTRACTS = new LinkedHashMap();

    public static Class<? extends Operator> getContractClass(Class<?> stubClass) {
        if (stubClass == null) {
            return null;
        }
        Class<? extends Operator> contract = STUB_CONTRACTS.get(stubClass);
        if (contract != null) {
            return contract;
        }
        for (Map.Entry<Class<?>, Class<Operator>> entry : STUB_CONTRACTS.entrySet()) {
            if (!entry.getKey().isAssignableFrom(stubClass)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static int getNumInputs(Class<? extends Operator<?>> contractType) {
        if (GenericDataSourceBase.class.isAssignableFrom(contractType)) {
            return 0;
        }
        if (GenericDataSinkBase.class.isAssignableFrom(contractType) || SingleInputOperator.class.isAssignableFrom(contractType)) {
            return 1;
        }
        if (DualInputOperator.class.isAssignableFrom(contractType)) {
            return 2;
        }
        throw new IllegalArgumentException("not supported");
    }

    public static void setInputs(Operator<?> contract, List<List<Operator>> inputs) {
        if (contract instanceof GenericDataSinkBase) {
            if (inputs.size() != 1) {
                throw new IllegalArgumentException("wrong number of inputs");
            }
            ((GenericDataSinkBase)contract).setInputs(inputs.get(0));
        } else if (contract instanceof SingleInputOperator) {
            if (inputs.size() != 1) {
                throw new IllegalArgumentException("wrong number of inputs");
            }
            ((SingleInputOperator)contract).setInputs(inputs.get(0));
        } else if (contract instanceof DualInputOperator) {
            if (inputs.size() != 2) {
                throw new IllegalArgumentException("wrong number of inputs");
            }
            ((DualInputOperator)contract).setFirstInputs(inputs.get(0));
            ((DualInputOperator)contract).setSecondInputs(inputs.get(1));
        }
    }

    static {
        STUB_CONTRACTS.put(GenericCollectorMap.class, CollectorMapOperatorBase.class);
        STUB_CONTRACTS.put(GroupReduceFunction.class, GroupReduceOperatorBase.class);
        STUB_CONTRACTS.put(CoGroupFunction.class, CoGroupOperatorBase.class);
        STUB_CONTRACTS.put(CrossFunction.class, CrossOperatorBase.class);
        STUB_CONTRACTS.put(FlatJoinFunction.class, JoinOperatorBase.class);
        STUB_CONTRACTS.put(FileInputFormat.class, GenericDataSourceBase.class);
        STUB_CONTRACTS.put(FileOutputFormat.class, GenericDataSinkBase.class);
        STUB_CONTRACTS.put(InputFormat.class, GenericDataSourceBase.class);
        STUB_CONTRACTS.put(OutputFormat.class, GenericDataSinkBase.class);
    }
}

