/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.util.List;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeComparator;

public abstract class CompositeType<T>
extends TypeInformation<T> {
    protected final Class<T> typeClass;

    public CompositeType(Class<T> typeClass) {
        this.typeClass = typeClass;
    }

    public abstract void getKey(String var1, int var2, List<FlatFieldDescriptor> var3);

    public abstract <X> TypeInformation<X> getTypeAt(int var1);

    protected abstract void initializeNewComparator(int var1);

    protected abstract void addCompareField(int var1, TypeComparator<?> var2);

    protected abstract TypeComparator<T> getNewComparator();

    public TypeComparator<T> createComparator(int[] logicalKeyFields, boolean[] orders, int logicalFieldOffset) {
        this.initializeNewComparator(logicalKeyFields.length);
        for (int logicalKeyFieldIndex = 0; logicalKeyFieldIndex < logicalKeyFields.length; ++logicalKeyFieldIndex) {
            int logicalKeyField = logicalKeyFields[logicalKeyFieldIndex];
            int logicalField = logicalFieldOffset;
            for (int localFieldId = 0; localFieldId < this.getArity(); ++localFieldId) {
                TypeInformation localFieldType = this.getTypeAt(localFieldId);
                if (localFieldType instanceof AtomicType && logicalField == logicalKeyField) {
                    this.addCompareField(localFieldId, ((AtomicType)((Object)localFieldType)).createComparator(orders[logicalKeyFieldIndex]));
                } else if (localFieldType instanceof CompositeType && logicalField <= logicalKeyField && logicalKeyField <= logicalField + (localFieldType.getTotalFields() - 1)) {
                    this.addCompareField(localFieldId, ((CompositeType)localFieldType).createComparator(new int[]{logicalKeyField}, new boolean[]{orders[logicalKeyFieldIndex]}, logicalField));
                }
                if (localFieldType instanceof CompositeType) {
                    logicalField += localFieldType.getTotalFields() - 1;
                }
                ++logicalField;
            }
        }
        return this.getNewComparator();
    }

    public static class FlatFieldDescriptor {
        private int keyPosition;
        private TypeInformation<?> type;

        public FlatFieldDescriptor(int keyPosition, TypeInformation<?> type) {
            if (!(type instanceof AtomicType)) {
                throw new IllegalArgumentException("A flattened field can only be an atomic type");
            }
            this.keyPosition = keyPosition;
            this.type = type;
        }

        public int getPosition() {
            return this.keyPosition;
        }

        public TypeInformation<?> getType() {
            return this.type;
        }

        public String toString() {
            return "FlatFieldDescriptor [position=" + this.keyPosition + " typeInfo=" + this.type + "]";
        }
    }
}

