/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public abstract class BasicTypeComparator<T extends Comparable<T>>
extends TypeComparator<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient T reference;
    protected final boolean ascendingComparison;
    private final TypeComparator[] comparators = new TypeComparator[]{this};

    protected BasicTypeComparator(boolean ascending) {
        this.ascendingComparison = ascending;
    }

    @Override
    public int hash(T value) {
        return value.hashCode();
    }

    @Override
    public void setReference(T toCompare) {
        this.reference = toCompare;
    }

    @Override
    public boolean equalToReference(T candidate) {
        return candidate.equals(this.reference);
    }

    @Override
    public int compareToReference(TypeComparator<T> referencedComparator) {
        int comp = ((BasicTypeComparator)referencedComparator).reference.compareTo(this.reference);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public int compare(T first, T second) {
        int cmp = first.compareTo(second);
        return this.ascendingComparison ? cmp : -cmp;
    }

    @Override
    public boolean invertNormalizedKey() {
        return !this.ascendingComparison;
    }

    @Override
    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    @Override
    public void writeWithKeyNormalization(T record, DataOutputView target) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int extractKeys(Object record, Object[] target, int index) {
        target[index] = record;
        return 1;
    }

    @Override
    public TypeComparator[] getFlatComparators() {
        return this.comparators;
    }

    @Override
    public T readWithKeyDenormalization(T reuse, DataInputView source) throws IOException {
        throw new UnsupportedOperationException();
    }
}

