/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.ByteValue;

public final class ByteValueSerializer
extends TypeSerializerSingleton<ByteValue> {
    private static final long serialVersionUID = 1L;
    public static final ByteValueSerializer INSTANCE = new ByteValueSerializer();

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public boolean isStateful() {
        return false;
    }

    @Override
    public ByteValue createInstance() {
        return new ByteValue();
    }

    @Override
    public ByteValue copy(ByteValue from) {
        return this.copy(from, new ByteValue());
    }

    @Override
    public ByteValue copy(ByteValue from, ByteValue reuse) {
        reuse.setValue(from.getValue());
        return reuse;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public void serialize(ByteValue record, DataOutputView target) throws IOException {
        record.write(target);
    }

    @Override
    public ByteValue deserialize(DataInputView source) throws IOException {
        return this.deserialize(new ByteValue(), source);
    }

    @Override
    public ByteValue deserialize(ByteValue reuse, DataInputView source) throws IOException {
        reuse.read(source);
        return reuse;
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.writeByte(source.readByte());
    }
}

