/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.base.BasicTypeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.MemorySegment;

public final class CharComparator
extends BasicTypeComparator<Character> {
    private static final long serialVersionUID = 1L;

    public CharComparator(boolean ascending) {
        super(ascending);
    }

    @Override
    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        char c2;
        char c1 = firstSource.readChar();
        int comp = c1 < (c2 = secondSource.readChar()) ? -1 : (c1 == c2 ? 0 : 1);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public boolean supportsNormalizedKey() {
        return true;
    }

    @Override
    public int getNormalizeKeyLen() {
        return 2;
    }

    @Override
    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < 2;
    }

    @Override
    public void putNormalizedKey(Character value, MemorySegment target, int offset, int numBytes) {
        if (numBytes == 2) {
            target.put(offset, (byte)(value.charValue() >>> 8 & 0xFF));
            target.put(offset + 1, (byte)(value.charValue() & 0xFF));
        } else if (numBytes > 0) {
            if (numBytes == 1) {
                target.put(offset, (byte)(value.charValue() >>> 8 & 0xFF));
            } else {
                target.put(offset, (byte)(value.charValue() >>> 8 & 0xFF));
                target.put(offset + 1, (byte)(value.charValue() & 0xFF));
                for (int i = 2; i < numBytes; ++i) {
                    target.put(offset + i, (byte)0);
                }
            }
        }
    }

    public CharComparator duplicate() {
        return new CharComparator(this.ascendingComparison);
    }
}

