/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.base.BasicTypeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.MemorySegment;

public final class IntComparator
extends BasicTypeComparator<Integer> {
    private static final long serialVersionUID = 1L;

    public IntComparator(boolean ascending) {
        super(ascending);
    }

    @Override
    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        int i2;
        int i1 = firstSource.readInt();
        int comp = i1 < (i2 = secondSource.readInt()) ? -1 : (i1 == i2 ? 0 : 1);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public boolean supportsNormalizedKey() {
        return true;
    }

    @Override
    public int getNormalizeKeyLen() {
        return 4;
    }

    @Override
    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < 4;
    }

    @Override
    public void putNormalizedKey(Integer iValue, MemorySegment target, int offset, int numBytes) {
        block5: {
            int value;
            block4: {
                value = iValue - Integer.MIN_VALUE;
                if (numBytes != 4) break block4;
                target.putIntBigEndian(offset, value);
                break block5;
            }
            if (numBytes <= 0) break block5;
            if (numBytes < 4) {
                int i = 0;
                while (numBytes > 0) {
                    target.put(offset + i, (byte)(value >>> (3 - i << 3)));
                    --numBytes;
                    ++i;
                }
            } else {
                target.putLongBigEndian(offset, value);
                for (int i = 4; i < numBytes; ++i) {
                    target.put(offset + i, (byte)0);
                }
            }
        }
    }

    public IntComparator duplicate() {
        return new IntComparator(this.ascendingComparison);
    }
}

