/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.record;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.Record;

public final class RecordSerializer
extends TypeSerializer<Record> {
    private static final long serialVersionUID = 1L;
    private static final RecordSerializer INSTANCE = new RecordSerializer();
    private static final int MAX_BIT = 128;

    public static final RecordSerializer get() {
        return INSTANCE;
    }

    private RecordSerializer() {
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public boolean isStateful() {
        return false;
    }

    @Override
    public Record createInstance() {
        return new Record();
    }

    @Override
    public Record copy(Record from) {
        return from.createCopy();
    }

    @Override
    public Record copy(Record from, Record reuse) {
        from.copyTo(reuse);
        return reuse;
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(Record record, DataOutputView target) throws IOException {
        record.serialize(target);
    }

    @Override
    public Record deserialize(DataInputView source) throws IOException {
        return this.deserialize(new Record(), source);
    }

    @Override
    public Record deserialize(Record target, DataInputView source) throws IOException {
        target.deserialize(source);
        return target;
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int val = source.readUnsignedByte();
        target.writeByte(val);
        if (val >= 128) {
            int curr;
            int shift = 7;
            val &= 0x7F;
            while ((curr = source.readUnsignedByte()) >= 128) {
                target.writeByte(curr);
                val |= (curr & 0x7F) << shift;
                shift += 7;
            }
            target.writeByte(curr);
            val |= curr << shift;
        }
        target.write(source, val);
    }
}

