/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.io;

import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class GenericInputSplit
implements InputSplit,
Serializable {
    private static final long serialVersionUID = 1L;
    private int partitionNumber;
    private int totalNumberOfPartitions;

    public GenericInputSplit() {
    }

    public GenericInputSplit(int partitionNumber, int totalNumberOfPartitions) {
        this.partitionNumber = partitionNumber;
        this.totalNumberOfPartitions = totalNumberOfPartitions;
    }

    @Override
    public int getSplitNumber() {
        return this.partitionNumber;
    }

    public int getTotalNumberOfSplits() {
        return this.totalNumberOfPartitions;
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.partitionNumber);
        out.writeInt(this.totalNumberOfPartitions);
    }

    @Override
    public void read(DataInputView in) throws IOException {
        this.partitionNumber = in.readInt();
        this.totalNumberOfPartitions = in.readInt();
    }

    public int hashCode() {
        return this.partitionNumber ^ this.totalNumberOfPartitions;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof GenericInputSplit) {
            GenericInputSplit other = (GenericInputSplit)obj;
            return this.partitionNumber == other.partitionNumber && this.totalNumberOfPartitions == other.totalNumberOfPartitions;
        }
        return false;
    }

    public String toString() {
        return "GenericSplit (" + this.partitionNumber + "/" + this.totalNumberOfPartitions + ")";
    }
}

