/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.io;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.core.io.StringRecord;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class LocatableInputSplit
implements InputSplit,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String[] EMPTY_ARR = new String[0];
    private int splitNumber;
    private String[] hostnames;

    public LocatableInputSplit(int splitNumber, String[] hostnames) {
        this.splitNumber = splitNumber;
        this.hostnames = hostnames == null ? EMPTY_ARR : hostnames;
    }

    public LocatableInputSplit(int splitNumber, String hostname) {
        String[] stringArray;
        this.splitNumber = splitNumber;
        if (hostname == null) {
            stringArray = EMPTY_ARR;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = hostname;
        }
        this.hostnames = stringArray;
    }

    public LocatableInputSplit() {
    }

    @Override
    public int getSplitNumber() {
        return this.splitNumber;
    }

    public String[] getHostnames() {
        return this.hostnames;
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.splitNumber);
        out.writeInt(this.hostnames.length);
        for (int i = 0; i < this.hostnames.length; ++i) {
            StringRecord.writeString(out, this.hostnames[i]);
        }
    }

    @Override
    public void read(DataInputView in) throws IOException {
        this.splitNumber = in.readInt();
        int numHosts = in.readInt();
        if (numHosts == 0) {
            this.hostnames = EMPTY_ARR;
        } else {
            this.hostnames = new String[numHosts];
            for (int i = 0; i < numHosts; ++i) {
                this.hostnames[i] = StringRecord.readString(in);
            }
        }
    }

    public int hashCode() {
        return this.splitNumber;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj instanceof LocatableInputSplit) {
            LocatableInputSplit other = (LocatableInputSplit)obj;
            return other.splitNumber == this.splitNumber && Arrays.deepEquals(other.hostnames, this.hostnames);
        }
        return false;
    }

    public String toString() {
        return "Locatable Split (" + this.splitNumber + ") at " + Arrays.toString(this.hostnames);
    }
}

