/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import org.apache.flink.types.BooleanValue;
import org.apache.flink.types.ByteValue;
import org.apache.flink.types.CharValue;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.FloatValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.ShortValue;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.Value;

public class JavaToValueConverter {
    public static Value convertBoxedJavaType(Object boxed) {
        if (boxed == null) {
            return null;
        }
        Class<?> clazz = boxed.getClass();
        if (clazz == String.class) {
            return new StringValue((String)boxed);
        }
        if (clazz == Integer.class) {
            return new IntValue((Integer)boxed);
        }
        if (clazz == Long.class) {
            return new LongValue((Long)boxed);
        }
        if (clazz == Double.class) {
            return new DoubleValue((Double)boxed);
        }
        if (clazz == Float.class) {
            return new FloatValue(((Float)boxed).floatValue());
        }
        if (clazz == Boolean.class) {
            return new BooleanValue((Boolean)boxed);
        }
        if (clazz == Byte.class) {
            return new ByteValue((Byte)boxed);
        }
        if (clazz == Short.class) {
            return new ShortValue((Short)boxed);
        }
        if (clazz == Character.class) {
            return new CharValue(((Character)boxed).charValue());
        }
        throw new IllegalArgumentException("Object is no primitive Java type.");
    }

    public static Object convertValueType(Value value) {
        if (value == null) {
            return null;
        }
        if (value instanceof StringValue) {
            return ((StringValue)value).getValue();
        }
        if (value instanceof IntValue) {
            return ((IntValue)value).getValue();
        }
        if (value instanceof LongValue) {
            return ((LongValue)value).getValue();
        }
        if (value instanceof DoubleValue) {
            return ((DoubleValue)value).getValue();
        }
        if (value instanceof FloatValue) {
            return Float.valueOf(((FloatValue)value).getValue());
        }
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).getValue();
        }
        if (value instanceof ByteValue) {
            return ((ByteValue)value).getValue();
        }
        if (value instanceof ShortValue) {
            return ((ShortValue)value).getValue();
        }
        if (value instanceof CharValue) {
            return Character.valueOf(((CharValue)value).getValue());
        }
        throw new IllegalArgumentException("Object is no primitive Java type.");
    }
}

