/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import org.apache.flink.types.BooleanValue;
import org.apache.flink.types.ByteValue;
import org.apache.flink.types.CharValue;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.FloatValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.NullValue;
import org.apache.flink.types.ShortValue;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.Value;

public class ValueUtil {
    public static Value toFlinkValueType(Object java) {
        if (java == null) {
            return NullValue.getInstance();
        }
        if (java.getClass() == Boolean.class) {
            return new BooleanValue((Boolean)java);
        }
        if (java.getClass() == Integer.class) {
            return new IntValue((Integer)java);
        }
        if (java.getClass() == Byte.class) {
            return new ByteValue((Byte)java);
        }
        if (java.getClass() == Character.class) {
            return new CharValue(((Character)java).charValue());
        }
        if (java.getClass() == Double.class) {
            return new DoubleValue((Double)java);
        }
        if (java.getClass() == Float.class) {
            return new FloatValue(((Float)java).floatValue());
        }
        if (java.getClass() == Long.class) {
            return new LongValue((Long)java);
        }
        if (java.getClass() == Short.class) {
            return new ShortValue((Short)java);
        }
        if (java.getClass() == String.class) {
            return new StringValue(((String)java).toString());
        }
        throw new IllegalArgumentException("unsupported Java value");
    }
}

