/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import org.apache.flink.types.parser.FieldParser;

public class DoubleParser
extends FieldParser<Double> {
    private static final Double DOUBLE_INSTANCE = 0.0;
    private double result;

    @Override
    public int parseField(byte[] bytes, int startPos, int limit, char delimiter, Double reusable) {
        int i;
        byte delByte = (byte)delimiter;
        for (i = startPos; i < limit && bytes[i] != delByte; ++i) {
        }
        String str = new String(bytes, startPos, i - startPos);
        try {
            this.result = Double.parseDouble(str);
            return i == limit ? limit : i + 1;
        }
        catch (NumberFormatException e) {
            this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_FORMAT_ERROR);
            return -1;
        }
    }

    @Override
    public Double createValue() {
        return DOUBLE_INSTANCE;
    }

    @Override
    public Double getLastResult() {
        return this.result;
    }

    public static final double parseField(byte[] bytes, int startPos, int length) {
        return DoubleParser.parseField(bytes, startPos, length, '\uffff');
    }

    public static final double parseField(byte[] bytes, int startPos, int length, char delimiter) {
        int i;
        if (length <= 0) {
            throw new NumberFormatException("Invalid input: Empty string");
        }
        byte delByte = (byte)delimiter;
        for (i = 0; i < length && bytes[i] != delByte; ++i) {
        }
        String str = new String(bytes, startPos, i);
        return Double.parseDouble(str);
    }
}

