/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.parser.FieldParser;

public class DoubleValueParser
extends FieldParser<DoubleValue> {
    private DoubleValue result;

    @Override
    public int parseField(byte[] bytes, int startPos, int limit, char delim, DoubleValue reusable) {
        int i;
        byte delByte = (byte)delim;
        for (i = startPos; i < limit && bytes[i] != delByte; ++i) {
        }
        String str = new String(bytes, startPos, i - startPos);
        try {
            double value = Double.parseDouble(str);
            reusable.setValue(value);
            this.result = reusable;
            return i == limit ? limit : i + 1;
        }
        catch (NumberFormatException e) {
            this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_FORMAT_ERROR);
            return -1;
        }
    }

    @Override
    public DoubleValue createValue() {
        return new DoubleValue();
    }

    @Override
    public DoubleValue getLastResult() {
        return this.result;
    }
}

