/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import org.apache.flink.types.parser.FieldParser;

public class FloatParser
extends FieldParser<Float> {
    private float result;

    @Override
    public int parseField(byte[] bytes, int startPos, int limit, char delim, Float reusable) {
        int i;
        byte delByte = (byte)delim;
        for (i = startPos; i < limit && bytes[i] != delByte; ++i) {
        }
        String str = new String(bytes, startPos, i - startPos);
        try {
            this.result = Float.parseFloat(str);
            return i == limit ? limit : i + 1;
        }
        catch (NumberFormatException e) {
            this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_FORMAT_ERROR);
            return -1;
        }
    }

    @Override
    public Float createValue() {
        return Float.valueOf(Float.MIN_VALUE);
    }

    @Override
    public Float getLastResult() {
        return Float.valueOf(this.result);
    }

    public static final float parseField(byte[] bytes, int startPos, int length) {
        return FloatParser.parseField(bytes, startPos, length, '\uffff');
    }

    public static final float parseField(byte[] bytes, int startPos, int length, char delimiter) {
        int i;
        if (length <= 0) {
            throw new NumberFormatException("Invalid input: Empty string");
        }
        byte delByte = (byte)delimiter;
        for (i = 0; i < length && bytes[i] != delByte; ++i) {
        }
        String str = new String(bytes, startPos, i);
        return Float.parseFloat(str);
    }
}

