/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import org.apache.flink.types.FloatValue;
import org.apache.flink.types.parser.FieldParser;

public class FloatValueParser
extends FieldParser<FloatValue> {
    private FloatValue result;

    @Override
    public int parseField(byte[] bytes, int startPos, int limit, char delim, FloatValue reusable) {
        int i;
        byte delByte = (byte)delim;
        for (i = startPos; i < limit && bytes[i] != delByte; ++i) {
        }
        String str = new String(bytes, startPos, i - startPos);
        try {
            float value = Float.parseFloat(str);
            reusable.setValue(value);
            this.result = reusable;
            return i == limit ? limit : i + 1;
        }
        catch (NumberFormatException e) {
            this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_FORMAT_ERROR);
            return -1;
        }
    }

    @Override
    public FloatValue createValue() {
        return new FloatValue();
    }

    @Override
    public FloatValue getLastResult() {
        return this.result;
    }
}

