/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import org.apache.flink.types.parser.FieldParser;

public class IntParser
extends FieldParser<Integer> {
    private static final long OVERFLOW_BOUND = Integer.MAX_VALUE;
    private static final long UNDERFLOW_BOUND = 0x80000000L;
    private int result;

    @Override
    public int parseField(byte[] bytes, int startPos, int limit, char delimiter, Integer reusable) {
        long val = 0L;
        boolean neg = false;
        if (bytes[startPos] == 45) {
            neg = true;
            if (++startPos == limit || bytes[startPos] == delimiter) {
                this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_ORPHAN_SIGN);
                return -1;
            }
        }
        for (int i = startPos; i < limit; ++i) {
            if (bytes[i] == delimiter) {
                this.result = (int)(neg ? -val : val);
                return i + 1;
            }
            if (bytes[i] < 48 || bytes[i] > 57) {
                this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_ILLEGAL_CHARACTER);
                return -1;
            }
            val *= 10L;
            if ((val += (long)(bytes[i] - 48)) <= Integer.MAX_VALUE || neg && val <= 0x80000000L) continue;
            this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_OVERFLOW_UNDERFLOW);
            return -1;
        }
        this.result = (int)(neg ? -val : val);
        return limit;
    }

    @Override
    public Integer createValue() {
        return Integer.MIN_VALUE;
    }

    @Override
    public Integer getLastResult() {
        return this.result;
    }

    public static final int parseField(byte[] bytes, int startPos, int length) {
        return IntParser.parseField(bytes, startPos, length, '\uffff');
    }

    public static final int parseField(byte[] bytes, int startPos, int length, char delimiter) {
        if (length <= 0) {
            throw new NumberFormatException("Invalid input: Empty string");
        }
        long val = 0L;
        boolean neg = false;
        if (bytes[startPos] == 45) {
            neg = true;
            if (--length == 0 || bytes[++startPos] == delimiter) {
                throw new NumberFormatException("Orphaned minus sign.");
            }
        }
        while (length > 0) {
            if (bytes[startPos] == delimiter) {
                return (int)(neg ? -val : val);
            }
            if (bytes[startPos] < 48 || bytes[startPos] > 57) {
                throw new NumberFormatException("Invalid character.");
            }
            val *= 10L;
            if (!((val += (long)(bytes[startPos] - 48)) <= Integer.MAX_VALUE || neg && val <= 0x80000000L)) {
                throw new NumberFormatException("Value overflow/underflow");
            }
            ++startPos;
            --length;
        }
        return (int)(neg ? -val : val);
    }
}

