/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import org.apache.flink.types.IntValue;
import org.apache.flink.types.parser.FieldParser;

public class IntValueParser
extends FieldParser<IntValue> {
    private static final long OVERFLOW_BOUND = Integer.MAX_VALUE;
    private static final long UNDERFLOW_BOUND = 0x80000000L;
    private IntValue result;

    @Override
    public int parseField(byte[] bytes, int startPos, int limit, char delimiter, IntValue reusable) {
        long val = 0L;
        boolean neg = false;
        this.result = reusable;
        if (bytes[startPos] == 45) {
            neg = true;
            if (++startPos == limit || bytes[startPos] == delimiter) {
                this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_ORPHAN_SIGN);
                return -1;
            }
        }
        for (int i = startPos; i < limit; ++i) {
            if (bytes[i] == delimiter) {
                reusable.setValue((int)(neg ? -val : val));
                return i + 1;
            }
            if (bytes[i] < 48 || bytes[i] > 57) {
                this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_ILLEGAL_CHARACTER);
                return -1;
            }
            val *= 10L;
            if ((val += (long)(bytes[i] - 48)) <= Integer.MAX_VALUE || neg && val <= 0x80000000L) continue;
            this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_OVERFLOW_UNDERFLOW);
            return -1;
        }
        reusable.setValue((int)(neg ? -val : val));
        return limit;
    }

    @Override
    public IntValue createValue() {
        return new IntValue();
    }

    @Override
    public IntValue getLastResult() {
        return this.result;
    }
}

