/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import org.apache.flink.types.ShortValue;
import org.apache.flink.types.parser.FieldParser;

public class ShortValueParser
extends FieldParser<ShortValue> {
    private static final int OVERFLOW_BOUND = Short.MAX_VALUE;
    private static final int UNDERFLOW_BOUND = 32768;
    private ShortValue result;

    @Override
    public int parseField(byte[] bytes, int startPos, int limit, char delimiter, ShortValue reusable) {
        int val = 0;
        boolean neg = false;
        this.result = reusable;
        if (bytes[startPos] == 45) {
            neg = true;
            if (++startPos == limit || bytes[startPos] == delimiter) {
                this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_ORPHAN_SIGN);
                return -1;
            }
        }
        for (int i = startPos; i < limit; ++i) {
            if (bytes[i] == delimiter) {
                reusable.setValue((short)(neg ? -val : val));
                return i + 1;
            }
            if (bytes[i] < 48 || bytes[i] > 57) {
                this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_ILLEGAL_CHARACTER);
                return -1;
            }
            val *= 10;
            if ((val += bytes[i] - 48) <= Short.MAX_VALUE || neg && val <= 32768) continue;
            this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_OVERFLOW_UNDERFLOW);
            return -1;
        }
        reusable.setValue((short)(neg ? -val : val));
        return limit;
    }

    @Override
    public ShortValue createValue() {
        return new ShortValue();
    }

    @Override
    public ShortValue getLastResult() {
        return this.result;
    }
}

