/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import org.apache.flink.types.parser.FieldParser;

public class StringParser
extends FieldParser<String> {
    private static final byte WHITESPACE_SPACE = 32;
    private static final byte WHITESPACE_TAB = 9;
    private static final byte QUOTE_DOUBLE = 34;
    private String result;

    @Override
    public int parseField(byte[] bytes, int startPos, int limit, char delim, String reusable) {
        byte current;
        int i;
        byte delByte = (byte)delim;
        for (i = startPos; i < limit && ((current = bytes[i]) == 32 || current == 9); ++i) {
        }
        ParserStates parserState = ParserStates.NONE;
        int endOfCellPosition = i - 1;
        while (parserState != ParserStates.STOP && endOfCellPosition < limit && ++endOfCellPosition != limit) {
            current = bytes[endOfCellPosition];
            if (current == delByte) {
                parserState = parserState == ParserStates.IN_QUOTE ? parserState : ParserStates.STOP;
                continue;
            }
            if (current != 34) continue;
            if (parserState == ParserStates.IN_QUOTE) {
                parserState = ParserStates.NONE;
                continue;
            }
            parserState = ParserStates.IN_QUOTE;
        }
        if (parserState == ParserStates.IN_QUOTE) {
            this.setErrorState(FieldParser.ParseErrorState.UNTERMINATED_QUOTED_STRING);
            return -1;
        }
        if (i < limit && bytes[i] == 34) {
            int endOfContent;
            current = bytes[endOfCellPosition - 1];
            if (current != 32 && current != 9 && current != 34) {
                this.setErrorState(FieldParser.ParseErrorState.UNQUOTED_CHARS_AFTER_QUOTED_STRING);
                return -1;
            }
            int skipAtEnd = 0;
            while (bytes[endOfCellPosition - 1 - skipAtEnd] == 32 || bytes[endOfCellPosition - 1 - skipAtEnd] == 9) {
                ++skipAtEnd;
            }
            boolean notEscaped = true;
            for (int counter = endOfContent = i + 1; counter < endOfCellPosition - skipAtEnd; ++counter) {
                boolean bl = notEscaped = bytes[counter] != 34 || !notEscaped;
                if (!notEscaped) continue;
                bytes[endOfContent++] = bytes[counter];
            }
            this.result = new String(bytes, i + 1, endOfContent - i - 1);
            return endOfCellPosition == limit ? limit : endOfCellPosition + 1;
        }
        this.result = new String(bytes, i, endOfCellPosition - i);
        return endOfCellPosition == limit ? limit : endOfCellPosition + 1;
    }

    @Override
    public String createValue() {
        return "";
    }

    @Override
    public String getLastResult() {
        return this.result;
    }

    private static enum ParserStates {
        NONE,
        IN_QUOTE,
        STOP;

    }
}

