/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.protocols.VersionedProtocol;

public final class ClassUtils {
    private static final Map<String, Class<?>> PRIMITIVE_TYPES = new HashMap(9);
    private static final Set<Class<?>> BOXED_TYPES = new HashSet();

    private ClassUtils() {
    }

    public static Class<? extends VersionedProtocol> getProtocolByName(String className) throws ClassNotFoundException {
        if (!className.contains("Protocol")) {
            System.out.println(className);
            throw new ClassNotFoundException("Only use this method for protocols!");
        }
        return Class.forName(className, true, ClassUtils.getClassLoader()).asSubclass(VersionedProtocol.class);
    }

    public static Class<? extends IOReadableWritable> getRecordByName(String className) throws ClassNotFoundException {
        return Class.forName(className, true, ClassUtils.getClassLoader());
    }

    public static Class<? extends FileSystem> getFileSystemByName(String className) throws ClassNotFoundException {
        return Class.forName(className, true, ClassUtils.getClassLoader()).asSubclass(FileSystem.class);
    }

    private static ClassLoader getClassLoader() {
        return ClassUtils.class.getClassLoader();
    }

    public static Class<?> resolveClassPrimitiveAware(String className) throws ClassNotFoundException {
        if (className == null) {
            throw new NullPointerException();
        }
        Class<?> primClass = PRIMITIVE_TYPES.get(className);
        if (primClass != null) {
            return primClass;
        }
        return Class.forName(className);
    }

    public static boolean isPrimitiveOrBoxedOrString(Class<?> clazz) {
        return clazz != null && (clazz.isPrimitive() || ClassUtils.isBoxedTypeOrString(clazz));
    }

    public static boolean isBoxedTypeOrString(Class<?> clazz) {
        return BOXED_TYPES.contains(clazz);
    }

    static {
        PRIMITIVE_TYPES.put("byte", Byte.TYPE);
        PRIMITIVE_TYPES.put("short", Short.TYPE);
        PRIMITIVE_TYPES.put("int", Integer.TYPE);
        PRIMITIVE_TYPES.put("long", Long.TYPE);
        PRIMITIVE_TYPES.put("float", Float.TYPE);
        PRIMITIVE_TYPES.put("double", Double.TYPE);
        PRIMITIVE_TYPES.put("boolean", Boolean.TYPE);
        PRIMITIVE_TYPES.put("char", Character.TYPE);
        PRIMITIVE_TYPES.put("void", Void.TYPE);
        BOXED_TYPES.add(Byte.class);
        BOXED_TYPES.add(Short.class);
        BOXED_TYPES.add(Integer.class);
        BOXED_TYPES.add(Long.class);
        BOXED_TYPES.add(Float.class);
        BOXED_TYPES.add(Double.class);
        BOXED_TYPES.add(Boolean.class);
        BOXED_TYPES.add(Character.class);
        BOXED_TYPES.add(Void.class);
        BOXED_TYPES.add(String.class);
    }
}

