/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

public enum OperatingSystem {
    LINUX,
    WINDOWS,
    MAC_OS,
    FREE_BSD,
    UNKNOWN;

    private static final OperatingSystem os;
    private static final String OS_KEY = "os.name";
    private static final String LINUX_OS_PREFIX = "Linux";
    private static final String WINDOWS_OS_PREFIX = "Windows";
    private static final String MAC_OS_PREFIX = "Mac";
    private static final String FREEBSD_OS_PREFIX = "FreeBSD";

    public static OperatingSystem getCurrentOperatingSystem() {
        return os;
    }

    public static boolean isWindows() {
        return OperatingSystem.getCurrentOperatingSystem() == WINDOWS;
    }

    public static boolean isLinux() {
        return OperatingSystem.getCurrentOperatingSystem() == LINUX;
    }

    public static boolean isMac() {
        return OperatingSystem.getCurrentOperatingSystem() == MAC_OS;
    }

    public static boolean isFreeBSD() {
        return OperatingSystem.getCurrentOperatingSystem() == FREE_BSD;
    }

    private static OperatingSystem readOSFromSystemProperties() {
        String osName = System.getProperty(OS_KEY);
        if (osName.startsWith(LINUX_OS_PREFIX)) {
            return LINUX;
        }
        if (osName.startsWith(WINDOWS_OS_PREFIX)) {
            return WINDOWS;
        }
        if (osName.startsWith(MAC_OS_PREFIX)) {
            return MAC_OS;
        }
        if (osName.startsWith(FREEBSD_OS_PREFIX)) {
            return FREE_BSD;
        }
        return UNKNOWN;
    }

    static {
        os = OperatingSystem.readOSFromSystemProperties();
    }
}

