/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class ReflectionUtil {
    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Class<T> getTemplateType(Class<?> clazz, int num) {
        return ReflectionUtil.getSuperTemplateTypes(clazz)[num];
    }

    public static <T> Class<T> getTemplateType(Class<?> clazz, Class<?> classWithParameter, int num) {
        return ReflectionUtil.getSuperTemplateTypes(clazz)[num];
    }

    public static <T> Class<T> getTemplateType1(Class<?> clazz) {
        return ReflectionUtil.getTemplateType(clazz, 0);
    }

    public static <T> Class<T> getTemplateType2(Class<?> clazz) {
        return ReflectionUtil.getTemplateType(clazz, 1);
    }

    public static <T> Class<T> getTemplateType3(Class<?> clazz) {
        return ReflectionUtil.getTemplateType(clazz, 2);
    }

    public static <T> Class<T> getTemplateType4(Class<?> clazz) {
        return ReflectionUtil.getTemplateType(clazz, 3);
    }

    public static <T> Class<T> getTemplateType5(Class<?> clazz) {
        return ReflectionUtil.getTemplateType(clazz, 4);
    }

    public static <T> Class<T> getTemplateType6(Class<?> clazz) {
        return ReflectionUtil.getTemplateType(clazz, 5);
    }

    public static <T> Class<T> getTemplateType7(Class<?> clazz) {
        return ReflectionUtil.getTemplateType(clazz, 6);
    }

    public static <T> Class<T> getTemplateType8(Class<?> clazz) {
        return ReflectionUtil.getTemplateType(clazz, 7);
    }

    public static Class<?>[] getSuperTemplateTypes(Class<?> clazz) {
        Type type = clazz.getGenericSuperclass();
        while (!(type instanceof ParameterizedType)) {
            if (clazz.getGenericSuperclass() == null) {
                throw new IllegalArgumentException();
            }
            type = clazz.getGenericSuperclass();
            clazz = clazz.getSuperclass();
        }
        return ReflectionUtil.getTemplateTypes((ParameterizedType)type);
    }

    public static Class<?>[] getSuperTemplateTypes(Class<?> clazz, Class<?> searchedSuperClass) {
        if (clazz == null || searchedSuperClass == null) {
            throw new NullPointerException();
        }
        Class<?> superClass = null;
        while ((superClass = clazz.getSuperclass()) != searchedSuperClass && (clazz = superClass) != null) {
        }
        if (clazz == null) {
            throw new IllegalArgumentException("The searched for superclass is not a superclass of the given class.");
        }
        Type type = clazz.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            return ReflectionUtil.getTemplateTypes((ParameterizedType)type);
        }
        throw new IllegalArgumentException("The searched for superclass is not a generic class.");
    }

    public static Class<?>[] getTemplateTypes(ParameterizedType paramterizedType) {
        Class[] types = new Class[paramterizedType.getActualTypeArguments().length];
        int i = 0;
        for (Type templateArgument : paramterizedType.getActualTypeArguments()) {
            assert (templateArgument instanceof Class);
            types[i++] = (Class)templateArgument;
        }
        return types;
    }

    public static Class<?>[] getTemplateTypes(Class<?> clazz) {
        Type type = clazz.getGenericSuperclass();
        assert (type instanceof ParameterizedType);
        ParameterizedType paramterizedType = (ParameterizedType)type;
        Class[] types = new Class[paramterizedType.getActualTypeArguments().length];
        int i = 0;
        for (Type templateArgument : paramterizedType.getActualTypeArguments()) {
            assert (templateArgument instanceof Class);
            types[i++] = (Class)templateArgument;
        }
        return types;
    }
}

