/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.java.graph;

import org.apache.flink.api.common.ProgramDescription;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.aggregation.Aggregations;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.DeltaIteration;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.examples.java.graph.util.ConnectedComponentsData;
import org.apache.flink.util.Collector;

public class ConnectedComponents
implements ProgramDescription {
    private static boolean fileOutput = false;
    private static String verticesPath = null;
    private static String edgesPath = null;
    private static String outputPath = null;
    private static int maxIterations = 10;

    public static void main(String ... args) throws Exception {
        if (!ConnectedComponents.parseParameters(args)) {
            return;
        }
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Long> vertices = ConnectedComponents.getVertexDataSet(env);
        FlatMapOperator edges = ConnectedComponents.getEdgeDataSet(env).flatMap((FlatMapFunction)new UndirectEdge());
        MapOperator verticesWithInitialId = vertices.map(new DuplicateValue());
        DeltaIteration iteration = verticesWithInitialId.iterateDelta((DataSet)verticesWithInitialId, maxIterations, new int[]{0});
        JoinOperator.EquiJoin changes = iteration.getWorkset().join((DataSet)edges).where(new int[]{0}).equalTo(new int[]{0}).with((JoinFunction)new NeighborWithComponentIDJoin()).groupBy(new int[]{0}).aggregate(Aggregations.MIN, 1).join((DataSet)iteration.getSolutionSet()).where(new int[]{0}).equalTo(new int[]{0}).with((FlatJoinFunction)new ComponentIdFilter());
        DataSet result = iteration.closeWith((DataSet)changes, (DataSet)changes);
        if (fileOutput) {
            result.writeAsCsv(outputPath, "\n", " ");
        } else {
            result.print();
        }
        env.execute("Connected Components Example");
    }

    public String getDescription() {
        return "Parameters: <vertices-path> <edges-path> <result-path> <max-number-of-iterations>";
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean parseParameters(String[] programArguments) {
        if (programArguments.length <= 0) {
            System.out.println("Executing Connected Components example with default parameters and built-in default data.");
            System.out.println("  Provide parameters to read input data from files.");
            System.out.println("  See the documentation for the correct format of input files.");
            System.out.println("  Usage: ConnectedComponents <vertices path> <edges path> <result path> <max number of iterations>");
            return true;
        }
        fileOutput = true;
        if (programArguments.length == 4) {
            verticesPath = programArguments[0];
            edgesPath = programArguments[1];
            outputPath = programArguments[2];
            maxIterations = Integer.parseInt(programArguments[3]);
            return true;
        }
        System.err.println("Usage: ConnectedComponents <vertices path> <edges path> <result path> <max number of iterations>");
        return false;
    }

    private static DataSet<Long> getVertexDataSet(ExecutionEnvironment env) {
        if (fileOutput) {
            return env.readCsvFile(verticesPath).types(Long.class).map((MapFunction)new MapFunction<Tuple1<Long>, Long>(){

                public Long map(Tuple1<Long> value) {
                    return (Long)value.f0;
                }
            });
        }
        return ConnectedComponentsData.getDefaultVertexDataSet(env);
    }

    private static DataSet<Tuple2<Long, Long>> getEdgeDataSet(ExecutionEnvironment env) {
        if (fileOutput) {
            return env.readCsvFile(edgesPath).fieldDelimiter(' ').types(Long.class, Long.class);
        }
        return ConnectedComponentsData.getDefaultEdgeDataSet(env);
    }

    @FunctionAnnotation.ConstantFieldsFirst(value={"0"})
    public static final class ComponentIdFilter
    implements FlatJoinFunction<Tuple2<Long, Long>, Tuple2<Long, Long>, Tuple2<Long, Long>> {
        public void join(Tuple2<Long, Long> candidate, Tuple2<Long, Long> old, Collector<Tuple2<Long, Long>> out) {
            if ((Long)candidate.f1 < (Long)old.f1) {
                out.collect(candidate);
            }
        }
    }

    @FunctionAnnotation.ConstantFieldsFirst(value={"1 -> 0"})
    @FunctionAnnotation.ConstantFieldsSecond(value={"1 -> 1"})
    public static final class NeighborWithComponentIDJoin
    implements JoinFunction<Tuple2<Long, Long>, Tuple2<Long, Long>, Tuple2<Long, Long>> {
        public Tuple2<Long, Long> join(Tuple2<Long, Long> vertexWithComponent, Tuple2<Long, Long> edge) {
            return new Tuple2(edge.f1, vertexWithComponent.f1);
        }
    }

    public static final class UndirectEdge
    implements FlatMapFunction<Tuple2<Long, Long>, Tuple2<Long, Long>> {
        Tuple2<Long, Long> invertedEdge = new Tuple2();

        public void flatMap(Tuple2<Long, Long> edge, Collector<Tuple2<Long, Long>> out) {
            this.invertedEdge.f0 = edge.f1;
            this.invertedEdge.f1 = edge.f0;
            out.collect(edge);
            out.collect(this.invertedEdge);
        }
    }

    @FunctionAnnotation.ConstantFields(value={"0 -> 0,1"})
    public static final class DuplicateValue<T>
    implements MapFunction<T, Tuple2<T, T>> {
        public Tuple2<T, T> map(T vertex) {
            return new Tuple2(vertex, vertex);
        }
    }
}

