/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.java.misc;

import java.util.HashSet;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.aggregation.Aggregations;
import org.apache.flink.api.java.io.RemoteCollectorConsumer;
import org.apache.flink.api.java.io.RemoteCollectorImpl;
import org.apache.flink.api.java.operators.AggregateOperator;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.util.Collector;

public class RemoteCollectorOutputFormatExample {
    public static void main(String[] args) throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.createRemoteEnvironment((String)"<remote>", (int)6124, (String[])new String[]{"/path/to/your/file.jar"});
        DataSource text = env.fromElements((Object[])new String[]{"To be, or not to be,--that is the question:--", "Whether 'tis nobler in the mind to suffer", "The slings and arrows of outrageous fortune", "Or to take arms against a sea of troubles,"});
        AggregateOperator counts = text.flatMap((FlatMapFunction)new LineSplitter()).groupBy(new int[]{0}).aggregate(Aggregations.SUM, 1);
        RemoteCollectorImpl.collectLocal((DataSet)counts, (RemoteCollectorConsumer)new RemoteCollectorConsumer<Tuple2<String, Integer>>(){

            public void collect(Tuple2<String, Integer> element) {
                System.out.println("word/occurrences:" + element);
            }
        });
        HashSet collection = new HashSet();
        RemoteCollectorImpl.collectLocal((DataSet)counts, collection);
        env.execute("WordCount Example with RemoteCollectorOutputFormat");
        System.out.println(collection);
        RemoteCollectorImpl.shutdownAll();
    }

    public static final class LineSplitter
    implements FlatMapFunction<String, Tuple2<String, Integer>> {
        public void flatMap(String value, Collector<Tuple2<String, Integer>> out) {
            String[] tokens;
            for (String token : tokens = value.toLowerCase().split("\\W+")) {
                if (token.length() <= 0) continue;
                out.collect((Object)new Tuple2((Object)token, (Object)1));
            }
        }
    }
}

