/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.java.ml.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.Random;

public class LinearRegressionDataGenerator {
    private static final String POINTS_FILE = "data";
    private static final long DEFAULT_SEED = 4650285087650871364L;
    private static final int DIMENSIONALITY = 1;
    private static final DecimalFormat FORMAT;
    private static final char DELIMITER = ' ';

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("LinearRegressionDataGenerator <numberOfDataPoints> [<seed>]");
            System.exit(1);
        }
        int numDataPoints = Integer.parseInt(args[0]);
        long firstSeed = args.length > 1 ? Long.parseLong(args[4]) : 4650285087650871364L;
        Random random = new Random(firstSeed);
        String tmpDir = System.getProperty("java.io.tmpdir");
        BufferedWriter pointsOut = null;
        try {
            pointsOut = new BufferedWriter(new FileWriter(new File(tmpDir + "/" + POINTS_FILE)));
            StringBuilder buffer = new StringBuilder();
            double[] point = new double[2];
            for (int i = 1; i <= numDataPoints; ++i) {
                point[0] = random.nextGaussian();
                point[1] = 2.0 * point[0] + 0.01 * random.nextGaussian();
                LinearRegressionDataGenerator.writePoint(point, buffer, pointsOut);
            }
        }
        finally {
            if (pointsOut != null) {
                pointsOut.close();
            }
        }
        System.out.println("Wrote " + numDataPoints + " data points to " + tmpDir + "/" + POINTS_FILE);
    }

    private static void writePoint(double[] data, StringBuilder buffer, BufferedWriter out) throws IOException {
        buffer.setLength(0);
        for (int j = 0; j < data.length; ++j) {
            buffer.append(FORMAT.format(data[j]));
            if (j >= data.length - 1) continue;
            buffer.append(' ');
        }
        out.write(buffer.toString());
        out.newLine();
    }

    static {
        Locale.setDefault(Locale.US);
        FORMAT = new DecimalFormat("#0.00");
    }
}

