/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.OutputStream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.admin.AdminUtils$;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignmentCompleted$;
import kafka.admin.ReassignmentFailed$;
import kafka.admin.ReassignmentInProgress$;
import kafka.admin.ReassignmentStatus;
import kafka.common.AdminCommandFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.ReassignedPartitionsContext;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ReassignPartitionsCommand$
implements Logging {
    public static final ReassignPartitionsCommand$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ReassignPartitionsCommand$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ReassignPartitionsCommand$ reassignPartitionsCommand$ = this;
        synchronized (reassignPartitionsCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void main(String[] stringArray) {
        OptionParser optionParser = new OptionParser();
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec = optionParser.accepts("topics-to-move-json-file", "The JSON file with the list of topics to reassign.This option or manual-assignment-json-file needs to be specified. The format to use is - \n{\"topics\":\n\t[{\"topic\": \"foo\"},{\"topic\": \"foo1\"}],\n\"version\":1\n}").withRequiredArg().describedAs("topics to reassign json file path").ofType(String.class);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec2 = optionParser.accepts("manual-assignment-json-file", "The JSON file with the list of manual reassignmentsThis option or topics-to-move-json-file needs to be specified. The format to use is - \n{\"partitions\":\n\t[{\"topic\": \"foo\",\n\t  \"partition\": 1,\n\t  \"replicas\": [1,2,3] }],\n\"version\":1\n}").withRequiredArg().describedAs("manual assignment json file path").ofType(String.class);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec3 = optionParser.accepts("broker-list", "The list of brokers to which the partitions need to be reassigned in the form \"0,1,2\". This is required for automatic topic reassignment.").withRequiredArg().describedAs("brokerlist").ofType(String.class);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec4 = optionParser.accepts("zookeeper", "REQUIRED: The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over.").withRequiredArg().describedAs("urls").ofType(String.class);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec5 = optionParser.accepts("execute", "This option does the actual reassignment. By default, the tool does a dry run").withOptionalArg().describedAs("execute").ofType(String.class);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec6 = optionParser.accepts("status-check-json-file", "REQUIRED: The JSON file with the list of partitions and the new replicas they should be reassigned to, which can be obtained from the output of a dry run.").withRequiredArg().describedAs("partition reassignment json file path").ofType(String.class);
        OptionSet optionSet = optionParser.parse(stringArray);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{argumentAcceptingOptionSpec4})).foreach((Function1)new Serializable(optionParser, optionSet){
            public static final long serialVersionUID = 0L;
            private final OptionParser parser$1;
            private final OptionSet options$1;

            public final void apply(ArgumentAcceptingOptionSpec<String> argumentAcceptingOptionSpec) {
                if (!this.options$1.has(argumentAcceptingOptionSpec)) {
                    System.err.println(new StringBuilder().append((Object)"Missing required argument \"").append(argumentAcceptingOptionSpec).append((Object)"\"").toString());
                    this.parser$1.printHelpOn((OutputStream)System.err);
                    System.exit(1);
                }
            }
            {
                this.parser$1 = optionParser;
                this.options$1 = optionSet;
            }
        });
        if (optionSet.has((OptionSpec)argumentAcceptingOptionSpec) && optionSet.has((OptionSpec)argumentAcceptingOptionSpec2)) {
            System.err.println("Only one of the json files should be specified");
            optionParser.printHelpOn((OutputStream)System.err);
            System.exit(1);
        }
        String string = (String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec4);
        ZkClient zkClient = new ZkClient(string, 30000, 30000, (ZkSerializer)ZKStringSerializer$.MODULE$);
        try {
            ObjectRef objectRef = new ObjectRef((Object)new HashMap());
            if (optionSet.has((OptionSpec)argumentAcceptingOptionSpec6)) {
                String string2 = (String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec6);
                String string3 = Utils$.MODULE$.readFileAsString(string2, Utils$.MODULE$.readFileAsString$default$2());
                Map<TopicAndPartition, Seq<Object>> map = ZkUtils$.MODULE$.parsePartitionReassignmentData(string3);
                Predef$.MODULE$.println((Object)"Status of partition reassignment:");
                Map<TopicAndPartition, ReassignmentStatus> map2 = this.checkIfReassignmentSucceeded(zkClient, map);
                map2.foreach((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Tuple2<TopicAndPartition, ReassignmentStatus> tuple2) {
                        ReassignmentStatus reassignmentStatus;
                        block5: {
                            block3: {
                                block4: {
                                    block2: {
                                        reassignmentStatus = (ReassignmentStatus)tuple2._2();
                                        ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
                                        ReassignmentStatus reassignmentStatus2 = reassignmentStatus;
                                        if (reassignmentCompleted$ != null ? !reassignmentCompleted$.equals(reassignmentStatus2) : reassignmentStatus2 != null) break block2;
                                        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Reassignment of partition %s completed successfully")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tuple2._1()})));
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block3;
                                    }
                                    ReassignmentFailed$ reassignmentFailed$ = ReassignmentFailed$.MODULE$;
                                    ReassignmentStatus reassignmentStatus3 = reassignmentStatus;
                                    if (reassignmentFailed$ != null ? !reassignmentFailed$.equals(reassignmentStatus3) : reassignmentStatus3 != null) break block4;
                                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Reassignment of partition %s failed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tuple2._1()})));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block3;
                                }
                                ReassignmentInProgress$ reassignmentInProgress$ = ReassignmentInProgress$.MODULE$;
                                ReassignmentStatus reassignmentStatus4 = reassignmentStatus;
                                if (reassignmentInProgress$ != null ? !reassignmentInProgress$.equals(reassignmentStatus4) : reassignmentStatus4 != null) break block5;
                                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Reassignment of partition %s is still in progress")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tuple2._1()})));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            return;
                        }
                        throw new MatchError((Object)reassignmentStatus);
                    }
                });
            } else if (optionSet.has((OptionSpec)argumentAcceptingOptionSpec)) {
                String string4 = (String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec);
                String string5 = (String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec3);
                String string6 = Utils$.MODULE$.readFileAsString(string4, Utils$.MODULE$.readFileAsString$default$2());
                int[] nArray = (int[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(string5)).split(',')).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final int apply(String string) {
                        return new StringOps(Predef$.MODULE$.augmentString(string)).toInt();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                Seq<String> seq = ZkUtils$.MODULE$.parseTopicsData(string6);
                scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> map = ZkUtils$.MODULE$.getReplicaAssignmentForTopics(zkClient, seq);
                scala.collection.immutable.Map map3 = map.groupBy((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<TopicAndPartition, Seq<Object>> tuple2) {
                        return ((TopicAndPartition)tuple2._1()).topic();
                    }
                });
                map3.foreach((Function1)new Serializable(objectRef, nArray){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef partitionsToBeReassigned$1;
                    private final int[] brokerListToReassign$1;

                    public final void apply(Tuple2<String, scala.collection.mutable.Map<TopicAndPartition, Seq<Object>>> tuple2) {
                        Map<Object, Seq<Object>> map = AdminUtils$.MODULE$.assignReplicasToBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(this.brokerListToReassign$1), ((TraversableOnce)tuple2._2()).size(), ((SeqLike)((Tuple2)((IterableLike)tuple2._2()).head())._2()).size(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
                        this.partitionsToBeReassigned$1.elem = ((Map)this.partitionsToBeReassigned$1.elem).$plus$plus((GenTraversableOnce)map.map((Function1)new Serializable(this, tuple2){
                            public static final long serialVersionUID = 0L;
                            private final Tuple2 topicInfo$1;

                            public final Tuple2<TopicAndPartition, Seq<Object>> apply(Tuple2<Object, Seq<Object>> tuple2) {
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition((String)this.topicInfo$1._1(), tuple2._1$mcI$sp())), tuple2._2());
                            }
                            {
                                this.topicInfo$1 = tuple2;
                            }
                        }, Map$.MODULE$.canBuildFrom()));
                    }
                    {
                        this.partitionsToBeReassigned$1 = objectRef;
                        this.brokerListToReassign$1 = nArray;
                    }
                });
            } else if (optionSet.has((OptionSpec)argumentAcceptingOptionSpec2)) {
                String string7 = (String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec2);
                String string8 = Utils$.MODULE$.readFileAsString(string7, Utils$.MODULE$.readFileAsString$default$2());
                objectRef.elem = ZkUtils$.MODULE$.parsePartitionReassignmentData(string8);
                if (((Map)objectRef.elem).isEmpty()) {
                    throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Partition reassignment data file %s is empty")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{argumentAcceptingOptionSpec2})));
                }
            } else {
                System.err.println("Missing json file. One of the file needs to be specified");
                optionParser.printHelpOn((OutputStream)System.err);
                System.exit(1);
            }
            if (optionSet.has((OptionSpec)argumentAcceptingOptionSpec) || optionSet.has((OptionSpec)argumentAcceptingOptionSpec2)) {
                if (optionSet.has((OptionSpec)argumentAcceptingOptionSpec5)) {
                    ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(zkClient, (Map<TopicAndPartition, Seq<Object>>)((Map)objectRef.elem));
                    if (reassignPartitionsCommand.reassignPartitions()) {
                        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Successfully started reassignment of partitions %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Map)objectRef.elem})));
                    } else {
                        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Failed to reassign partitions %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Map)objectRef.elem})));
                    }
                } else {
                    System.out.println(new StringBuilder().append((Object)"This is a dry run (Use --execute to do the actual reassignment. The following is the replica assignment. Save it for the status check option.\n").append((Object)ZkUtils$.MODULE$.getPartitionReassignmentZkData((Map<TopicAndPartition, Seq<Object>>)((Map)objectRef.elem))).toString());
                }
            }
            if (zkClient == null) return;
        }
        catch (Throwable throwable) {
            try {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Partitions reassignment failed due to ").append((Object)throwable.getMessage()).toString());
                Predef$.MODULE$.println((Object)Utils$.MODULE$.stackTrace(throwable));
            }
            finally {
                if (zkClient == null) return;
                zkClient.close();
            }
        }
        zkClient.close();
    }

    private Map<TopicAndPartition, ReassignmentStatus> checkIfReassignmentSucceeded(ZkClient zkClient, Map<TopicAndPartition, Seq<Object>> map) {
        Map map2 = ZkUtils$.MODULE$.getPartitionsBeingReassigned(zkClient).mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(ReassignedPartitionsContext reassignedPartitionsContext) {
                return reassignedPartitionsContext.newReplicas();
            }
        });
        return (Map)map.map((Function1)new Serializable(zkClient, map, map2){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$1;
            private final Map partitionsToBeReassigned$2;
            private final Map partitionsBeingReassigned$1;

            public final Tuple2<TopicAndPartition, ReassignmentStatus> apply(Tuple2<TopicAndPartition, Seq<Object>> tuple2) {
                return new Tuple2(tuple2._1(), (Object)ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.zkClient$1, (TopicAndPartition)tuple2._1(), (Seq<Object>)((Seq)tuple2._2()), (Map<TopicAndPartition, Seq<Object>>)this.partitionsToBeReassigned$2, (Map<TopicAndPartition, Seq<Object>>)this.partitionsBeingReassigned$1));
            }
            {
                this.zkClient$1 = zkClient;
                this.partitionsToBeReassigned$2 = map;
                this.partitionsBeingReassigned$1 = map2;
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    public ReassignmentStatus checkIfPartitionReassignmentSucceeded(ZkClient zkClient, TopicAndPartition topicAndPartition, Seq<Object> seq, Map<TopicAndPartition, Seq<Object>> map, Map<TopicAndPartition, Seq<Object>> map2) {
        Option option;
        block4: {
            Product product;
            block3: {
                Seq<Object> seq2;
                Seq seq3;
                block2: {
                    seq3 = (Seq)map.apply((Object)topicAndPartition);
                    option = map2.get((Object)topicAndPartition);
                    if (!(option instanceof Some)) break block2;
                    product = ReassignmentInProgress$.MODULE$;
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                Seq<Object> seq4 = seq2 = ZkUtils$.MODULE$.getReplicasForPartition(zkClient, topicAndPartition.topic(), topicAndPartition.partition());
                Seq seq5 = seq3;
                product = !(seq4 != null ? !seq4.equals((Object)seq5) : seq5 != null) ? ReassignmentCompleted$.MODULE$ : ReassignmentFailed$.MODULE$;
            }
            return product;
        }
        throw new MatchError((Object)option);
    }

    private ReassignPartitionsCommand$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

