/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hbc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.twitter.hbc.RateTracker;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class BasicRateTracker
implements RateTracker {
    private final int granularityMillis;
    private final int numBuckets;
    private final RateUpdater rateUpdater;
    private ScheduledFuture<?> future;
    private final ScheduledExecutorService executor;

    public BasicRateTracker(int granularityMillis, int numBuckets, boolean startPaused, ScheduledExecutorService executor) {
        Preconditions.checkArgument((numBuckets > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((granularityMillis > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((granularityMillis / numBuckets > 0 ? 1 : 0) != 0);
        this.granularityMillis = granularityMillis;
        this.numBuckets = numBuckets;
        this.executor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)executor);
        this.rateUpdater = new RateUpdater(startPaused);
    }

    @Override
    public void eventObserved() {
        this.rateUpdater.eventObserved();
    }

    @Override
    public void pause() {
        this.rateUpdater.pause();
    }

    @Override
    public void resume() {
        this.rateUpdater.resume();
    }

    @Override
    public void start() {
        this.future = this.executor.scheduleAtFixedRate(this.rateUpdater, this.granularityMillis / this.numBuckets, this.granularityMillis / this.numBuckets, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        if (this.future != null) {
            this.future.cancel(false);
        }
    }

    @Override
    public void shutdown() {
        this.stop();
        this.executor.shutdown();
    }

    @VisibleForTesting
    void recalculate() {
        this.rateUpdater.run();
    }

    @Override
    public double getCurrentRateSeconds() {
        return this.rateUpdater.getCurrentRateSeconds();
    }

    class RateUpdater
    implements Runnable {
        private final int[] buckets;
        private final Object lock;
        private boolean paused;
        private double rate;
        private boolean rateValid = false;
        private int total;
        private int currentBucket;
        private boolean previouslyPaused;
        private int currentBucketCount;

        RateUpdater() {
            this(false);
        }

        RateUpdater(boolean paused) {
            this.buckets = new int[BasicRateTracker.this.numBuckets];
            this.paused = paused;
            this.rate = Double.NaN;
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.lock;
            synchronized (object) {
                int currentCount = this.currentBucketCount;
                this.currentBucketCount = 0;
                if (this.paused) {
                    this.previouslyPaused = true;
                    return;
                }
                if (this.previouslyPaused) {
                    this.previouslyPaused = false;
                    return;
                }
                int prevBucket = this.currentBucket;
                this.currentBucket = (this.currentBucket + 1) % BasicRateTracker.this.numBuckets;
                if (this.currentBucket == 0) {
                    this.rateValid = true;
                }
                int prevBucketCount = this.buckets[prevBucket];
                this.buckets[prevBucket] = currentCount;
                this.total += currentCount - prevBucketCount;
                if (this.rateValid) {
                    this.rate = (double)this.total * 1000.0 / (double)BasicRateTracker.this.granularityMillis;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void eventObserved() {
            Object object = this.lock;
            synchronized (object) {
                ++this.currentBucketCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pause() {
            Object object = this.lock;
            synchronized (object) {
                this.paused = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resume() {
            Object object = this.lock;
            synchronized (object) {
                this.paused = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double getCurrentRateSeconds() {
            Object object = this.lock;
            synchronized (object) {
                return this.rate;
            }
        }
    }
}

