/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.avro;

import java.io.Closeable;
import java.io.IOException;
import org.apache.avro.file.SeekableInput;
import org.apache.flink.core.fs.FSDataInputStream;

public class FSDataInputStreamWrapper
implements Closeable,
SeekableInput {
    private final FSDataInputStream stream;
    private final long len;
    private long pos;

    public FSDataInputStreamWrapper(FSDataInputStream stream, long len) {
        this.stream = stream;
        this.len = len;
        this.pos = 0L;
    }

    public long length() {
        return this.len;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.stream.read(b, off, len);
        this.pos += (long)read;
        return read;
    }

    public void seek(long p) throws IOException {
        this.stream.seek(p);
        this.pos = p;
    }

    public long tell() throws IOException {
        return this.pos;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

