/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.core.fs.Path;

public class AvroOutputFormat<E>
extends FileOutputFormat<E> {
    private static final long serialVersionUID = 1L;
    private final Class<E> avroValueType;
    private Schema userDefinedSchema = null;
    private transient DataFileWriter<E> dataFileWriter;

    public AvroOutputFormat(Path filePath, Class<E> type) {
        super(filePath);
        this.avroValueType = type;
    }

    public AvroOutputFormat(Class<E> type) {
        this.avroValueType = type;
    }

    public void setSchema(Schema schema) {
        this.userDefinedSchema = schema;
    }

    public void writeRecord(E record) throws IOException {
        this.dataFileWriter.append(record);
    }

    public void open(int taskNumber, int numTasks) throws IOException {
        SpecificDatumWriter datumWriter;
        super.open(taskNumber, numTasks);
        Schema schema = null;
        if (SpecificRecordBase.class.isAssignableFrom(this.avroValueType)) {
            datumWriter = new SpecificDatumWriter(this.avroValueType);
            try {
                schema = ((SpecificRecordBase)this.avroValueType.newInstance()).getSchema();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e.getMessage());
            }
        } else {
            datumWriter = new ReflectDatumWriter(this.avroValueType);
            schema = ReflectData.get().getSchema(this.avroValueType);
        }
        this.dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);
        if (this.userDefinedSchema == null) {
            this.dataFileWriter.create(schema, (OutputStream)this.stream);
        } else {
            this.dataFileWriter.create(this.userDefinedSchema, (OutputStream)this.stream);
        }
    }

    public void close() throws IOException {
        this.dataFileWriter.flush();
        this.dataFileWriter.close();
        super.close();
    }
}

