/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.compiler.costs;

public class Costs
implements Comparable<Costs>,
Cloneable {
    public static final double UNKNOWN = -1.0;
    private double networkCost;
    private double diskCost;
    private double cpuCost;
    private double heuristicNetworkCost;
    private double heuristicDiskCost;
    private double heuristicCpuCost;

    public Costs() {
    }

    public Costs(double networkCost, double diskCost) {
        this.setNetworkCost(networkCost);
        this.setDiskCost(diskCost);
    }

    public Costs(double networkCost, double diskCost, double cpuCost) {
        this.setNetworkCost(networkCost);
        this.setDiskCost(diskCost);
        this.setCpuCost(cpuCost);
    }

    public double getNetworkCost() {
        return this.networkCost;
    }

    public void setNetworkCost(double bytes) {
        if (bytes != -1.0 && !(bytes >= 0.0)) {
            throw new IllegalArgumentException();
        }
        this.networkCost = bytes;
    }

    public void addNetworkCost(double bytes) {
        this.networkCost = this.networkCost < 0.0 || bytes < 0.0 ? -1.0 : this.networkCost + bytes;
    }

    public double getDiskCost() {
        return this.diskCost;
    }

    public void setDiskCost(double bytes) {
        if (bytes != -1.0 && !(bytes >= 0.0)) {
            throw new IllegalArgumentException();
        }
        this.diskCost = bytes;
    }

    public void addDiskCost(double bytes) {
        this.diskCost = this.diskCost < 0.0 || bytes < 0.0 ? -1.0 : this.diskCost + bytes;
    }

    public double getCpuCost() {
        return this.cpuCost;
    }

    public void setCpuCost(double cost) {
        if (cost != -1.0 && !(cost >= 0.0)) {
            throw new IllegalArgumentException();
        }
        this.cpuCost = cost;
    }

    public void addCpuCost(double cost) {
        this.cpuCost = this.cpuCost < 0.0 || cost < 0.0 ? -1.0 : this.cpuCost + cost;
    }

    public double getHeuristicNetworkCost() {
        return this.heuristicNetworkCost;
    }

    public void setHeuristicNetworkCost(double cost) {
        if (cost <= 0.0) {
            throw new IllegalArgumentException("Heuristic costs must be positive.");
        }
        this.heuristicNetworkCost = cost;
    }

    public void addHeuristicNetworkCost(double cost) {
        if (cost <= 0.0) {
            throw new IllegalArgumentException("Heuristic costs must be positive.");
        }
        this.heuristicNetworkCost += cost;
        if (this.heuristicNetworkCost < 0.0) {
            this.heuristicNetworkCost = Double.MAX_VALUE;
        }
    }

    public double getHeuristicDiskCost() {
        return this.heuristicDiskCost;
    }

    public void setHeuristicDiskCost(double cost) {
        if (cost <= 0.0) {
            throw new IllegalArgumentException("Heuristic costs must be positive.");
        }
        this.heuristicDiskCost = cost;
    }

    public void addHeuristicDiskCost(double cost) {
        if (cost <= 0.0) {
            throw new IllegalArgumentException("Heuristic costs must be positive.");
        }
        this.heuristicDiskCost += cost;
        if (this.heuristicDiskCost < 0.0) {
            this.heuristicDiskCost = Double.MAX_VALUE;
        }
    }

    public double getHeuristicCpuCost() {
        return this.heuristicCpuCost;
    }

    public void setHeuristicCpuCost(double cost) {
        if (cost <= 0.0) {
            throw new IllegalArgumentException("Heuristic costs must be positive.");
        }
        this.heuristicCpuCost = cost;
    }

    public void addHeuristicCpuCost(double cost) {
        if (cost <= 0.0) {
            throw new IllegalArgumentException("Heuristic costs must be positive.");
        }
        this.heuristicCpuCost += cost;
        if (this.heuristicCpuCost < 0.0) {
            this.heuristicCpuCost = Double.MAX_VALUE;
        }
    }

    public void addCosts(Costs other) {
        this.networkCost = this.networkCost == -1.0 || other.networkCost == -1.0 ? -1.0 : (this.networkCost += other.networkCost);
        this.diskCost = this.diskCost == -1.0 || other.diskCost == -1.0 ? -1.0 : (this.diskCost += other.diskCost);
        this.cpuCost = this.cpuCost == -1.0 || other.cpuCost == -1.0 ? -1.0 : (this.cpuCost += other.cpuCost);
        this.heuristicNetworkCost += other.heuristicNetworkCost;
        this.heuristicDiskCost += other.heuristicDiskCost;
        this.heuristicCpuCost += other.heuristicCpuCost;
    }

    public void subtractCosts(Costs other) {
        if (this.networkCost != -1.0 && other.networkCost != -1.0) {
            this.networkCost -= other.networkCost;
            if (this.networkCost < 0.0) {
                throw new IllegalArgumentException("Cannot subtract more cost then there is.");
            }
        }
        if (this.diskCost != -1.0 && other.diskCost != -1.0) {
            this.diskCost -= other.diskCost;
            if (this.diskCost < 0.0) {
                throw new IllegalArgumentException("Cannot subtract more cost then there is.");
            }
        }
        if (this.cpuCost != -1.0 && other.cpuCost != -1.0) {
            this.cpuCost -= other.cpuCost;
            if (this.cpuCost < 0.0) {
                throw new IllegalArgumentException("Cannot subtract more cost then there is.");
            }
        }
        this.heuristicNetworkCost -= other.heuristicNetworkCost;
        if (this.heuristicNetworkCost < 0.0) {
            throw new IllegalArgumentException("Cannot subtract more cost then there is.");
        }
        this.heuristicDiskCost -= other.heuristicDiskCost;
        if (this.heuristicDiskCost < 0.0) {
            throw new IllegalArgumentException("Cannot subtract more cost then there is.");
        }
        this.heuristicCpuCost -= other.heuristicCpuCost;
        if (this.heuristicCpuCost < 0.0) {
            throw new IllegalArgumentException("Cannot subtract more cost then there is.");
        }
    }

    public void multiplyWith(int factor) {
        this.networkCost = this.networkCost < 0.0 ? -1.0 : this.networkCost * (double)factor;
        this.diskCost = this.diskCost < 0.0 ? -1.0 : this.diskCost * (double)factor;
        this.cpuCost = this.cpuCost < 0.0 ? -1.0 : this.cpuCost * (double)factor;
        this.heuristicNetworkCost = this.heuristicNetworkCost < 0.0 ? -1.0 : this.heuristicNetworkCost * (double)factor;
        this.heuristicDiskCost = this.heuristicDiskCost < 0.0 ? -1.0 : this.heuristicDiskCost * (double)factor;
        this.heuristicCpuCost = this.heuristicCpuCost < 0.0 ? -1.0 : this.heuristicCpuCost * (double)factor;
    }

    public void divideBy(int factor) {
        this.networkCost = this.networkCost < 0.0 ? -1.0 : this.networkCost / (double)factor;
        this.diskCost = this.diskCost < 0.0 ? -1.0 : this.diskCost / (double)factor;
        this.cpuCost = this.cpuCost < 0.0 ? -1.0 : this.cpuCost / (double)factor;
        this.heuristicNetworkCost = this.heuristicNetworkCost < 0.0 ? -1.0 : this.heuristicNetworkCost / (double)factor;
        this.heuristicDiskCost = this.heuristicDiskCost < 0.0 ? -1.0 : this.heuristicDiskCost / (double)factor;
        this.heuristicCpuCost = this.heuristicCpuCost < 0.0 ? -1.0 : this.heuristicCpuCost / (double)factor;
    }

    @Override
    public int compareTo(Costs o) {
        if (this.networkCost != -1.0 && o.networkCost != -1.0) {
            if (this.networkCost != o.networkCost) {
                return this.networkCost < o.networkCost ? -1 : 1;
            }
        } else {
            if (this.heuristicNetworkCost < o.heuristicNetworkCost) {
                return -1;
            }
            if (this.heuristicNetworkCost > o.heuristicNetworkCost) {
                return 1;
            }
        }
        if (this.diskCost != -1.0 && o.diskCost != -1.0) {
            if (this.diskCost != o.diskCost) {
                return this.diskCost < o.diskCost ? -1 : 1;
            }
        } else {
            if (this.heuristicDiskCost < o.heuristicDiskCost) {
                return -1;
            }
            if (this.heuristicDiskCost > o.heuristicDiskCost) {
                return 1;
            }
        }
        if (this.cpuCost != -1.0 && o.cpuCost != -1.0) {
            return this.cpuCost < o.cpuCost ? -1 : (this.cpuCost > o.cpuCost ? 1 : 0);
        }
        if (this.heuristicCpuCost < o.heuristicCpuCost) {
            return -1;
        }
        if (this.heuristicCpuCost > o.heuristicCpuCost) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long cpuCostBits = Double.doubleToLongBits(this.cpuCost);
        long heuristicCpuCostBits = Double.doubleToLongBits(this.heuristicCpuCost);
        long heuristicNetworkCostBits = Double.doubleToLongBits(this.heuristicNetworkCost);
        long heuristicDiskCostBits = Double.doubleToLongBits(this.heuristicDiskCost);
        long networkCostBits = Double.doubleToLongBits(this.networkCost);
        long diskCostBits = Double.doubleToLongBits(this.diskCost);
        result = 31 * result + (int)(cpuCostBits ^ cpuCostBits >>> 32);
        result = 31 * result + (int)(heuristicCpuCostBits ^ heuristicCpuCostBits >>> 32);
        result = 31 * result + (int)(heuristicNetworkCostBits ^ heuristicNetworkCostBits >>> 32);
        result = 31 * result + (int)(heuristicDiskCostBits ^ heuristicDiskCostBits >>> 32);
        result = 31 * result + (int)(networkCostBits ^ networkCostBits >>> 32);
        result = 31 * result + (int)(diskCostBits ^ diskCostBits >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj.getClass() == this.getClass()) {
            Costs other = (Costs)obj;
            return this.networkCost == other.networkCost & this.diskCost == other.diskCost & this.cpuCost == other.cpuCost & this.heuristicNetworkCost == other.heuristicNetworkCost & this.heuristicDiskCost == other.heuristicDiskCost & this.heuristicCpuCost == other.heuristicCpuCost;
        }
        return false;
    }

    public String toString() {
        return "Costs [networkCost=" + this.networkCost + ", diskCost=" + this.diskCost + ", cpuCost=" + this.cpuCost + ", heuristicNetworkCost=" + this.heuristicNetworkCost + ", heuristicDiskCost=" + this.heuristicDiskCost + ", heuristicCpuCost=" + this.heuristicCpuCost + "]";
    }

    public Costs clone() {
        try {
            return (Costs)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

