/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.compiler.dag;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.io.NonParallelInput;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.api.common.operators.GenericDataSourceBase;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.compiler.DataStatistics;
import org.apache.flink.compiler.PactCompiler;
import org.apache.flink.compiler.costs.CostEstimator;
import org.apache.flink.compiler.costs.Costs;
import org.apache.flink.compiler.dag.OptimizerNode;
import org.apache.flink.compiler.dag.PactConnection;
import org.apache.flink.compiler.plan.PlanNode;
import org.apache.flink.compiler.plan.SourcePlanNode;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Visitable;
import org.apache.flink.util.Visitor;

public class DataSourceNode
extends OptimizerNode {
    private final boolean sequentialInput;

    public DataSourceNode(GenericDataSourceBase<?, ?> pactContract) {
        super((Operator<?>)pactContract);
        if (pactContract.getUserCodeWrapper().getUserCodeClass() == null) {
            throw new IllegalArgumentException("Input format has not been set.");
        }
        if (NonParallelInput.class.isAssignableFrom(pactContract.getUserCodeWrapper().getUserCodeClass())) {
            this.setDegreeOfParallelism(1);
            this.sequentialInput = true;
        } else {
            this.sequentialInput = false;
        }
    }

    public GenericDataSourceBase<?, ?> getPactContract() {
        return (GenericDataSourceBase)super.getPactContract();
    }

    @Override
    public String getName() {
        return "Data Source";
    }

    @Override
    public void setDegreeOfParallelism(int degreeOfParallelism) {
        if (!this.sequentialInput) {
            super.setDegreeOfParallelism(degreeOfParallelism);
        }
    }

    @Override
    public List<PactConnection> getIncomingConnections() {
        return Collections.emptyList();
    }

    @Override
    public void setInput(Map<Operator<?>, OptimizerNode> contractToNode) {
    }

    @Override
    protected void computeOperatorSpecificDefaultEstimates(DataStatistics statistics) {
        if (statistics != null) {
            BaseStatistics bs;
            String inFormatDescription;
            block14: {
                InputFormat format = null;
                inFormatDescription = "<unknown>";
                try {
                    format = (InputFormat)this.getPactContract().getFormatWrapper().getUserCodeObject();
                    Configuration config = this.getPactContract().getParameters();
                    format.configure(config);
                }
                catch (Throwable t) {
                    if (PactCompiler.LOG.isWarnEnabled()) {
                        PactCompiler.LOG.warn("Could not instantiate InputFormat to obtain statistics. Limited statistics will be available.", t);
                    }
                    return;
                }
                try {
                    inFormatDescription = format.toString();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                String statisticsKey = this.getPactContract().getStatisticsKey();
                BaseStatistics cachedStatistics = statistics.getBaseStatistics(statisticsKey);
                bs = null;
                try {
                    bs = format.getStatistics(cachedStatistics);
                }
                catch (Throwable t) {
                    if (!PactCompiler.LOG.isWarnEnabled()) break block14;
                    PactCompiler.LOG.warn("Error obtaining statistics from input format: " + t.getMessage(), t);
                }
            }
            if (bs != null) {
                long card;
                long len = bs.getTotalInputSize();
                if (len == -1L) {
                    if (PactCompiler.LOG.isInfoEnabled()) {
                        PactCompiler.LOG.info("Compiler could not determine the size of input '" + inFormatDescription + "'. Using default estimates.");
                    }
                } else if (len >= 0L) {
                    this.estimatedOutputSize = len;
                }
                if ((card = bs.getNumberOfRecords()) != -1L) {
                    this.estimatedNumRecords = card;
                }
            }
        }
    }

    @Override
    public void computeInterestingPropertiesForInputs(CostEstimator estimator) {
    }

    @Override
    public void computeUnclosedBranchStack() {
        this.openBranches = Collections.emptyList();
    }

    @Override
    public List<PlanNode> getAlternativePlans(CostEstimator estimator) {
        if (this.cachedPlans != null) {
            return this.cachedPlans;
        }
        SourcePlanNode candidate = new SourcePlanNode(this, "DataSource (" + this.getPactContract().getName() + ")");
        candidate.updatePropertiesWithUniqueSets(this.getUniqueFields());
        Costs costs = new Costs();
        if (FileInputFormat.class.isAssignableFrom(this.getPactContract().getFormatWrapper().getUserCodeClass()) && this.estimatedOutputSize >= 0L) {
            estimator.addFileInputCost(this.estimatedOutputSize, costs);
        }
        candidate.setCosts(costs);
        ArrayList<PlanNode> plans = new ArrayList<PlanNode>(1);
        plans.add(candidate);
        this.cachedPlans = plans;
        return plans;
    }

    @Override
    public boolean isFieldConstant(int input, int fieldNumber) {
        return false;
    }

    @Override
    public void accept(Visitor<OptimizerNode> visitor) {
        if (visitor.preVisit((Visitable)this)) {
            visitor.postVisit((Visitable)this);
        }
    }
}

