/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.compiler.dag;

import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.SingleInputOperator;
import org.apache.flink.api.common.operators.base.GroupReduceOperatorBase;
import org.apache.flink.compiler.CompilerException;
import org.apache.flink.compiler.DataStatistics;
import org.apache.flink.compiler.PactCompiler;
import org.apache.flink.compiler.dag.SingleInputNode;
import org.apache.flink.compiler.operators.AllGroupReduceProperties;
import org.apache.flink.compiler.operators.AllGroupWithPartialPreGroupProperties;
import org.apache.flink.compiler.operators.GroupReduceProperties;
import org.apache.flink.compiler.operators.GroupReduceWithCombineProperties;
import org.apache.flink.compiler.operators.OperatorDescriptorSingle;
import org.apache.flink.configuration.Configuration;

public class GroupReduceNode
extends SingleInputNode {
    private final List<OperatorDescriptorSingle> possibleProperties;
    private GroupReduceNode combinerUtilityNode;

    public GroupReduceNode(GroupReduceOperatorBase<?, ?, ?> operator) {
        super((SingleInputOperator<?, ?, ?>)operator);
        if (this.keys == null) {
            this.setDegreeOfParallelism(1);
        }
        this.possibleProperties = this.initPossibleProperties(operator.getCustomPartitioner());
    }

    public GroupReduceNode(GroupReduceNode reducerToCopyForCombiner) {
        super(reducerToCopyForCombiner);
        this.possibleProperties = Collections.emptyList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<OperatorDescriptorSingle> initPossibleProperties(Partitioner<?> customPartitioner) {
        boolean useCombiner;
        Configuration conf = this.getPactContract().getParameters();
        String localStrategy = conf.getString("LOCAL_STRATEGY", null);
        if (localStrategy != null) {
            if ("LOCAL_STRATEGY_SORT".equals(localStrategy)) {
                useCombiner = false;
            } else {
                if (!"LOCAL_STRATEGY_COMBINING_SORT".equals(localStrategy)) throw new CompilerException("Invalid local strategy hint for match contract: " + localStrategy);
                if (!this.isCombineable()) {
                    PactCompiler.LOG.warn("Strategy hint for GroupReduce '" + this.getPactContract().getName() + "' requires combinable reduce, but user function is not marked combinable.");
                }
                useCombiner = true;
            }
        } else {
            useCombiner = this.isCombineable();
        }
        Ordering groupOrder = null;
        if (this.getPactContract() instanceof GroupReduceOperatorBase && (groupOrder = this.getPactContract().getGroupOrder()) != null && groupOrder.getNumberOfFields() == 0) {
            groupOrder = null;
        }
        OperatorDescriptorSingle operatorDescriptorSingle = useCombiner ? (this.keys == null ? new AllGroupWithPartialPreGroupProperties() : new GroupReduceWithCombineProperties(this.keys, groupOrder, customPartitioner)) : (this.keys == null ? new AllGroupReduceProperties() : new GroupReduceProperties(this.keys, groupOrder, customPartitioner));
        return Collections.singletonList(operatorDescriptorSingle);
    }

    public GroupReduceOperatorBase<?, ?, ?> getPactContract() {
        return (GroupReduceOperatorBase)super.getPactContract();
    }

    public boolean isCombineable() {
        return this.getPactContract().isCombinable();
    }

    @Override
    public String getName() {
        return "GroupReduce";
    }

    @Override
    protected List<OperatorDescriptorSingle> getPossibleProperties() {
        return this.possibleProperties;
    }

    @Override
    protected void computeOperatorSpecificDefaultEstimates(DataStatistics statistics) {
    }

    public GroupReduceNode getCombinerUtilityNode() {
        if (this.combinerUtilityNode == null) {
            this.combinerUtilityNode = new GroupReduceNode(this);
            this.combinerUtilityNode.estimatedOutputSize = this.getPredecessorNode().getEstimatedOutputSize();
            this.combinerUtilityNode.estimatedNumRecords = this.getPredecessorNode().getEstimatedNumRecords();
        }
        return this.combinerUtilityNode;
    }
}

