/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.compiler.dag;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.operators.DualInputOperator;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.compiler.CompilerException;
import org.apache.flink.compiler.DataStatistics;
import org.apache.flink.compiler.dag.TwoInputNode;
import org.apache.flink.compiler.operators.AbstractJoinDescriptor;
import org.apache.flink.compiler.operators.HashJoinBuildFirstProperties;
import org.apache.flink.compiler.operators.HashJoinBuildSecondProperties;
import org.apache.flink.compiler.operators.OperatorDescriptorDual;
import org.apache.flink.compiler.operators.SortMergeJoinDescriptor;
import org.apache.flink.configuration.Configuration;

public class MatchNode
extends TwoInputNode {
    private List<OperatorDescriptorDual> dataProperties;

    public MatchNode(JoinOperatorBase<?, ?, ?, ?> joinOperatorBase) {
        super((DualInputOperator<?, ?, ?, ?>)joinOperatorBase);
        this.dataProperties = this.getDataProperties(joinOperatorBase, joinOperatorBase.getJoinHint());
    }

    public JoinOperatorBase<?, ?, ?, ?> getPactContract() {
        return (JoinOperatorBase)super.getPactContract();
    }

    @Override
    public String getName() {
        return "Join";
    }

    @Override
    protected List<OperatorDescriptorDual> getPossibleProperties() {
        return this.dataProperties;
    }

    public void makeJoinWithSolutionSet(int solutionsetInputIndex) {
        AbstractJoinDescriptor op;
        if (solutionsetInputIndex == 0) {
            op = new HashJoinBuildFirstProperties(this.keys1, this.keys2);
        } else if (solutionsetInputIndex == 1) {
            op = new HashJoinBuildSecondProperties(this.keys1, this.keys2);
        } else {
            throw new IllegalArgumentException();
        }
        this.dataProperties = Collections.singletonList(op);
    }

    @Override
    protected void computeOperatorSpecificDefaultEstimates(DataStatistics statistics) {
        long card1 = this.getFirstPredecessorNode().getEstimatedNumRecords();
        long card2 = this.getSecondPredecessorNode().getEstimatedNumRecords();
        long l = this.estimatedNumRecords = card1 < 0L || card2 < 0L ? -1L : Math.max(card1, card2);
        if (this.estimatedNumRecords >= 0L) {
            float width;
            float width1 = this.getFirstPredecessorNode().getEstimatedAvgWidthPerOutputRecord();
            float width2 = this.getSecondPredecessorNode().getEstimatedAvgWidthPerOutputRecord();
            float f = width = width1 <= 0.0f || width2 <= 0.0f ? -1.0f : width1 + width2;
            if (width > 0.0f) {
                this.estimatedOutputSize = (long)(width * (float)this.estimatedNumRecords);
            }
        }
    }

    private List<OperatorDescriptorDual> getDataProperties(JoinOperatorBase<?, ?, ?, ?> joinOperatorBase, JoinOperatorBase.JoinHint joinHint) {
        Configuration conf = joinOperatorBase.getParameters();
        String localStrategy = conf.getString("LOCAL_STRATEGY", null);
        if (localStrategy != null) {
            AbstractJoinDescriptor fixedDriverStrat;
            if ("LOCAL_STRATEGY_SORT_BOTH_MERGE".equals(localStrategy) || "LOCAL_STRATEGY_SORT_FIRST_MERGE".equals(localStrategy) || "LOCAL_STRATEGY_SORT_SECOND_MERGE".equals(localStrategy) || "LOCAL_STRATEGY_MERGE".equals(localStrategy)) {
                fixedDriverStrat = new SortMergeJoinDescriptor(this.keys1, this.keys2);
            } else if ("LOCAL_STRATEGY_HASH_BUILD_FIRST".equals(localStrategy)) {
                fixedDriverStrat = new HashJoinBuildFirstProperties(this.keys1, this.keys2);
            } else if ("LOCAL_STRATEGY_HASH_BUILD_SECOND".equals(localStrategy)) {
                fixedDriverStrat = new HashJoinBuildSecondProperties(this.keys1, this.keys2);
            } else {
                throw new CompilerException("Invalid local strategy hint for match contract: " + localStrategy);
            }
            ArrayList<OperatorDescriptorDual> list = new ArrayList<OperatorDescriptorDual>();
            list.add(fixedDriverStrat);
            return list;
        }
        ArrayList<OperatorDescriptorDual> list = new ArrayList<OperatorDescriptorDual>();
        joinHint = joinHint == null ? JoinOperatorBase.JoinHint.OPTIMIZER_CHOOSES : joinHint;
        switch (joinHint) {
            case BROADCAST_HASH_FIRST: {
                list.add(new HashJoinBuildFirstProperties(this.keys1, this.keys2, true, false, false));
                break;
            }
            case BROADCAST_HASH_SECOND: {
                list.add(new HashJoinBuildSecondProperties(this.keys1, this.keys2, false, true, false));
                break;
            }
            case REPARTITION_HASH_FIRST: {
                list.add(new HashJoinBuildFirstProperties(this.keys1, this.keys2, false, false, true));
                break;
            }
            case REPARTITION_HASH_SECOND: {
                list.add(new HashJoinBuildSecondProperties(this.keys1, this.keys2, false, false, true));
                break;
            }
            case REPARTITION_SORT_MERGE: {
                list.add(new SortMergeJoinDescriptor(this.keys1, this.keys2, false, false, true));
                break;
            }
            case OPTIMIZER_CHOOSES: {
                list.add(new SortMergeJoinDescriptor(this.keys1, this.keys2));
                list.add(new HashJoinBuildFirstProperties(this.keys1, this.keys2));
                list.add(new HashJoinBuildSecondProperties(this.keys1, this.keys2));
                break;
            }
            default: {
                throw new CompilerException("Unrecognized join hint: " + joinHint);
            }
        }
        return list;
    }
}

