/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.compiler.dag;

import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.base.DeltaIterationBase;
import org.apache.flink.compiler.DataStatistics;
import org.apache.flink.compiler.dag.AbstractPartialSolutionNode;
import org.apache.flink.compiler.dag.OptimizerNode;
import org.apache.flink.compiler.dag.PactConnection;
import org.apache.flink.compiler.dag.WorksetIterationNode;
import org.apache.flink.compiler.dataproperties.GlobalProperties;
import org.apache.flink.compiler.dataproperties.LocalProperties;
import org.apache.flink.compiler.plan.Channel;
import org.apache.flink.compiler.plan.SolutionSetPlanNode;

public class SolutionSetNode
extends AbstractPartialSolutionNode {
    private final WorksetIterationNode iterationNode;

    public SolutionSetNode(DeltaIterationBase.SolutionSetPlaceHolder<?> psph, WorksetIterationNode iterationNode) {
        super((Operator<?>)psph);
        this.iterationNode = iterationNode;
    }

    public void setCandidateProperties(GlobalProperties gProps, LocalProperties lProps, Channel initialInput) {
        this.cachedPlans = Collections.singletonList(new SolutionSetPlanNode(this, "SolutionSet(" + this.getPactContract().getName() + ")", gProps, lProps, initialInput));
    }

    public SolutionSetPlanNode getCurrentSolutionSetPlanNode() {
        if (this.cachedPlans != null) {
            return (SolutionSetPlanNode)this.cachedPlans.get(0);
        }
        throw new IllegalStateException();
    }

    @Override
    public WorksetIterationNode getIterationNode() {
        return this.iterationNode;
    }

    @Override
    public void computeOutputEstimates(DataStatistics statistics) {
        this.copyEstimates(this.iterationNode.getInitialSolutionSetPredecessorNode());
    }

    public DeltaIterationBase.SolutionSetPlaceHolder<?> getPactContract() {
        return (DeltaIterationBase.SolutionSetPlaceHolder)super.getPactContract();
    }

    @Override
    public String getName() {
        return "Solution Set";
    }

    @Override
    public void computeUnclosedBranchStack() {
        if (this.openBranches != null) {
            return;
        }
        PactConnection solutionSetInput = this.iterationNode.getFirstIncomingConnection();
        OptimizerNode solutionSetSource = solutionSetInput.getSource();
        this.addClosedBranches(solutionSetSource.closedBranchingNodes);
        List<OptimizerNode.UnclosedBranchDescriptor> fromInput = solutionSetSource.getBranchesForParent(solutionSetInput);
        this.openBranches = fromInput == null || fromInput.isEmpty() ? Collections.emptyList() : fromInput;
    }
}

