/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.compiler.dataproperties;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.compiler.CompilerException;
import org.apache.flink.compiler.dag.OptimizerNode;
import org.apache.flink.compiler.dataproperties.PartitioningProperty;
import org.apache.flink.compiler.plan.Channel;
import org.apache.flink.compiler.util.Utils;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;

public class GlobalProperties
implements Cloneable {
    private PartitioningProperty partitioning = PartitioningProperty.RANDOM;
    private FieldList partitioningFields;
    private Ordering ordering;
    private Set<FieldSet> uniqueFieldCombinations;
    private Partitioner<?> customPartitioner;

    public void setHashPartitioned(FieldList partitionedFields) {
        if (partitionedFields == null) {
            throw new NullPointerException();
        }
        this.partitioning = PartitioningProperty.HASH_PARTITIONED;
        this.partitioningFields = partitionedFields;
        this.ordering = null;
    }

    public void setRangePartitioned(Ordering ordering) {
        if (ordering == null) {
            throw new NullPointerException();
        }
        this.partitioning = PartitioningProperty.RANGE_PARTITIONED;
        this.ordering = ordering;
        this.partitioningFields = ordering.getInvolvedIndexes();
    }

    public void setAnyPartitioning(FieldList partitionedFields) {
        if (partitionedFields == null) {
            throw new NullPointerException();
        }
        this.partitioning = PartitioningProperty.ANY_PARTITIONING;
        this.partitioningFields = partitionedFields;
        this.ordering = null;
    }

    public void setRandomDistribution() {
        this.partitioning = PartitioningProperty.RANDOM;
        this.partitioningFields = null;
        this.ordering = null;
    }

    public void setFullyReplicated() {
        this.partitioning = PartitioningProperty.FULL_REPLICATION;
        this.partitioningFields = null;
        this.ordering = null;
    }

    public void setForcedRebalanced() {
        this.partitioning = PartitioningProperty.FORCED_REBALANCED;
        this.partitioningFields = null;
        this.ordering = null;
    }

    public void setCustomPartitioned(FieldList partitionedFields, Partitioner<?> partitioner) {
        if (partitionedFields == null || partitioner == null) {
            throw new NullPointerException();
        }
        this.partitioning = PartitioningProperty.CUSTOM_PARTITIONING;
        this.partitioningFields = partitionedFields;
        this.ordering = null;
        this.customPartitioner = partitioner;
    }

    public void addUniqueFieldCombination(FieldSet fields) {
        if (fields == null) {
            return;
        }
        if (this.uniqueFieldCombinations == null) {
            this.uniqueFieldCombinations = new HashSet<FieldSet>();
        }
        this.uniqueFieldCombinations.add(fields);
    }

    public void clearUniqueFieldCombinations() {
        if (this.uniqueFieldCombinations != null) {
            this.uniqueFieldCombinations = null;
        }
    }

    public Set<FieldSet> getUniqueFieldCombination() {
        return this.uniqueFieldCombinations;
    }

    public FieldList getPartitioningFields() {
        return this.partitioningFields;
    }

    public Ordering getPartitioningOrdering() {
        return this.ordering;
    }

    public PartitioningProperty getPartitioning() {
        return this.partitioning;
    }

    public Partitioner<?> getCustomPartitioner() {
        return this.customPartitioner;
    }

    public boolean isPartitionedOnFields(FieldSet fields) {
        if (this.partitioning.isPartitionedOnKey() && fields.isValidSubset((FieldSet)this.partitioningFields)) {
            return true;
        }
        if (this.uniqueFieldCombinations != null) {
            for (FieldSet set : this.uniqueFieldCombinations) {
                if (!fields.isValidSubset(set)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean matchesOrderedPartitioning(Ordering o) {
        if (this.partitioning == PartitioningProperty.RANGE_PARTITIONED) {
            if (this.ordering.getNumberOfFields() > o.getNumberOfFields()) {
                return false;
            }
            for (int i = 0; i < this.ordering.getNumberOfFields(); ++i) {
                if (this.ordering.getFieldNumber(i) != o.getFieldNumber(i)) {
                    return false;
                }
                Order oo = o.getOrder(i);
                Order to = this.ordering.getOrder(i);
                if (oo == Order.NONE || !(oo == Order.ANY ? to == Order.NONE : oo != to)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isFullyReplicated() {
        return this.partitioning == PartitioningProperty.FULL_REPLICATION;
    }

    public boolean isTrivial() {
        return this.partitioning == PartitioningProperty.RANDOM;
    }

    public void reset() {
        this.partitioning = PartitioningProperty.RANDOM;
        this.ordering = null;
        this.partitioningFields = null;
    }

    public GlobalProperties filterByNodesConstantSet(OptimizerNode node, int input) {
        Iterator i$;
        if (this.ordering != null) {
            i$ = this.ordering.getInvolvedIndexes().iterator();
            while (i$.hasNext()) {
                int col = (Integer)i$.next();
                if (node.isFieldConstant(input, col)) continue;
                return new GlobalProperties();
            }
        }
        if (this.partitioningFields != null) {
            i$ = this.partitioningFields.iterator();
            while (i$.hasNext()) {
                int colIndex = (Integer)i$.next();
                if (node.isFieldConstant(input, colIndex)) continue;
                return new GlobalProperties();
            }
        }
        if (this.uniqueFieldCombinations != null) {
            HashSet<FieldSet> newSet = new HashSet<FieldSet>();
            newSet.addAll(this.uniqueFieldCombinations);
            Iterator combos = newSet.iterator();
            block2: while (combos.hasNext()) {
                FieldSet current = (FieldSet)combos.next();
                for (Integer field : current) {
                    if (node.isFieldConstant(input, field)) continue;
                    combos.remove();
                    continue block2;
                }
            }
            if (newSet.size() != this.uniqueFieldCombinations.size()) {
                GlobalProperties gp = this.clone();
                gp.uniqueFieldCombinations = newSet.isEmpty() ? null : newSet;
                return gp;
            }
        }
        if (this.partitioning == PartitioningProperty.FULL_REPLICATION) {
            return new GlobalProperties();
        }
        return this;
    }

    public void parameterizeChannel(Channel channel, boolean globalDopChange) {
        switch (this.partitioning) {
            case RANDOM: {
                channel.setShipStrategy(globalDopChange ? ShipStrategyType.PARTITION_RANDOM : ShipStrategyType.FORWARD);
                break;
            }
            case FULL_REPLICATION: {
                channel.setShipStrategy(ShipStrategyType.BROADCAST);
                break;
            }
            case ANY_PARTITIONING: 
            case HASH_PARTITIONED: {
                channel.setShipStrategy(ShipStrategyType.PARTITION_HASH, Utils.createOrderedFromSet((FieldSet)this.partitioningFields));
                break;
            }
            case RANGE_PARTITIONED: {
                channel.setShipStrategy(ShipStrategyType.PARTITION_RANGE, this.ordering.getInvolvedIndexes(), this.ordering.getFieldSortDirections());
                break;
            }
            case FORCED_REBALANCED: {
                channel.setShipStrategy(ShipStrategyType.PARTITION_RANDOM);
                break;
            }
            case CUSTOM_PARTITIONING: {
                channel.setShipStrategy(ShipStrategyType.PARTITION_CUSTOM, this.partitioningFields, this.customPartitioner);
                break;
            }
            default: {
                throw new CompilerException("Unsupported partitioning strategy");
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.partitioning == null ? 0 : this.partitioning.ordinal());
        result = 31 * result + (this.partitioningFields == null ? 0 : this.partitioningFields.hashCode());
        result = 31 * result + (this.ordering == null ? 0 : this.ordering.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof GlobalProperties) {
            GlobalProperties other = (GlobalProperties)obj;
            return this.partitioning == other.partitioning && (this.ordering == other.ordering || this.ordering != null && this.ordering.equals((Object)other.ordering)) && (this.partitioningFields == other.partitioningFields || this.partitioningFields != null && this.partitioningFields.equals((Object)other.partitioningFields)) && (this.uniqueFieldCombinations == other.uniqueFieldCombinations || this.uniqueFieldCombinations != null && this.uniqueFieldCombinations.equals(other.uniqueFieldCombinations));
        }
        return false;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder("GlobalProperties [partitioning=" + (Object)((Object)this.partitioning) + (this.partitioningFields == null ? "" : ", on fields " + this.partitioningFields) + (this.ordering == null ? "" : ", with ordering " + this.ordering));
        if (this.uniqueFieldCombinations == null) {
            bld.append(']');
        } else {
            bld.append(" - Unique field groups: ");
            bld.append(this.uniqueFieldCombinations);
            bld.append(']');
        }
        return bld.toString();
    }

    public GlobalProperties clone() {
        GlobalProperties newProps = new GlobalProperties();
        newProps.partitioning = this.partitioning;
        newProps.partitioningFields = this.partitioningFields;
        newProps.ordering = this.ordering;
        newProps.customPartitioner = this.customPartitioner;
        newProps.uniqueFieldCombinations = this.uniqueFieldCombinations == null ? null : new HashSet<FieldSet>(this.uniqueFieldCombinations);
        return newProps;
    }

    public static final GlobalProperties combine(GlobalProperties gp1, GlobalProperties gp2) {
        if (gp1.isFullyReplicated()) {
            if (gp2.isFullyReplicated()) {
                return new GlobalProperties();
            }
            return gp2;
        }
        if (gp2.isFullyReplicated()) {
            return gp1;
        }
        if (gp1.ordering != null) {
            return gp1;
        }
        if (gp2.ordering != null) {
            return gp2;
        }
        if (gp1.partitioningFields != null) {
            return gp1;
        }
        if (gp2.partitioningFields != null) {
            return gp2;
        }
        if (gp1.uniqueFieldCombinations != null) {
            return gp1;
        }
        if (gp2.uniqueFieldCombinations != null) {
            return gp2;
        }
        if (gp1.getPartitioning().isPartitioned()) {
            return gp1;
        }
        if (gp2.getPartitioning().isPartitioned()) {
            return gp2;
        }
        return gp1;
    }
}

