/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.compiler.deadlockdetect;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.flink.compiler.deadlockdetect.DeadlockEdge;
import org.apache.flink.compiler.deadlockdetect.DeadlockVertex;
import org.apache.flink.compiler.plan.PlanNode;

public class DeadlockGraph {
    public Set<DeadlockVertex> vertices = new HashSet<DeadlockVertex>();

    public Set<DeadlockVertex> vertices() {
        return this.vertices;
    }

    public DeadlockVertex addVertex(PlanNode original) {
        DeadlockVertex v = new DeadlockVertex(original);
        this.vertices.add(v);
        return v;
    }

    public void addEdge(PlanNode source, PlanNode destination) {
        DeadlockVertex dest = null;
        for (DeadlockVertex v : this.vertices) {
            if (!v.getOriginal().equals(destination)) continue;
            dest = v;
        }
        for (DeadlockVertex v : this.vertices) {
            if (!v.getOriginal().equals(source)) continue;
            v.addEdge(dest);
        }
    }

    public long size() {
        return this.vertices.size();
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("------------ GRAPH ------------\n");
        for (DeadlockVertex n : this.vertices) {
            out.append("Node " + n + "_\n");
            for (DeadlockEdge a : n.getOutEdges()) {
                out.append("\t->" + a.getDestination() + "\n");
            }
            out.append("\n");
        }
        return out.toString();
    }

    public boolean hasCycle() {
        Set<DeadlockVertex> vertexCollect = this.vertices();
        for (DeadlockVertex v : vertexCollect) {
            v.setInDegree(0);
        }
        for (DeadlockVertex v : vertexCollect) {
            for (DeadlockEdge edge : v.getOutEdges()) {
                edge.getDestination().setInDegree(edge.getDestination().getInDegree() + 1);
            }
        }
        LinkedList<DeadlockVertex> q = new LinkedList<DeadlockVertex>();
        for (DeadlockVertex v : vertexCollect) {
            if (v.getInDegree() != 0) continue;
            q.offer(v);
        }
        while (!q.isEmpty()) {
            DeadlockVertex v = (DeadlockVertex)q.poll();
            this.vertices.remove(v);
            for (DeadlockEdge e : v.getOutEdges()) {
                DeadlockVertex w = e.getDestination();
                w.setInDegree(w.getInDegree() - 1);
                if (w.getInDegree() != 0) continue;
                q.offer(w);
            }
        }
        return !vertexCollect.isEmpty();
    }
}

