/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.compiler.operators;

import java.util.Collections;
import java.util.List;
import org.apache.flink.compiler.costs.Costs;
import org.apache.flink.compiler.dag.GroupReduceNode;
import org.apache.flink.compiler.dag.SingleInputNode;
import org.apache.flink.compiler.dataproperties.GlobalProperties;
import org.apache.flink.compiler.dataproperties.LocalProperties;
import org.apache.flink.compiler.dataproperties.PartitioningProperty;
import org.apache.flink.compiler.dataproperties.RequestedGlobalProperties;
import org.apache.flink.compiler.dataproperties.RequestedLocalProperties;
import org.apache.flink.compiler.operators.OperatorDescriptorSingle;
import org.apache.flink.compiler.plan.Channel;
import org.apache.flink.compiler.plan.SingleInputPlanNode;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;

public final class AllGroupWithPartialPreGroupProperties
extends OperatorDescriptorSingle {
    @Override
    public DriverStrategy getStrategy() {
        return DriverStrategy.ALL_GROUP_REDUCE;
    }

    @Override
    public SingleInputPlanNode instantiate(Channel in, SingleInputNode node) {
        if (in.getShipStrategy() == ShipStrategyType.FORWARD) {
            return new SingleInputPlanNode(node, "GroupReduce (" + node.getPactContract().getName() + ")", in, DriverStrategy.ALL_GROUP_REDUCE);
        }
        Channel toCombiner = new Channel(in.getSource());
        toCombiner.setShipStrategy(ShipStrategyType.FORWARD);
        GroupReduceNode combinerNode = ((GroupReduceNode)node).getCombinerUtilityNode();
        combinerNode.setDegreeOfParallelism(in.getSource().getDegreeOfParallelism());
        SingleInputPlanNode combiner = new SingleInputPlanNode(combinerNode, "Combine (" + node.getPactContract().getName() + ")", toCombiner, DriverStrategy.ALL_GROUP_COMBINE);
        combiner.setCosts(new Costs(0.0, 0.0));
        combiner.initProperties(toCombiner.getGlobalProperties(), toCombiner.getLocalProperties());
        Channel toReducer = new Channel(combiner);
        toReducer.setShipStrategy(in.getShipStrategy(), in.getShipStrategyKeys(), in.getShipStrategySortOrder());
        toReducer.setLocalStrategy(in.getLocalStrategy(), in.getLocalStrategyKeys(), in.getLocalStrategySortOrder());
        return new SingleInputPlanNode(node, "GroupReduce (" + node.getPactContract().getName() + ")", toReducer, DriverStrategy.ALL_GROUP_REDUCE);
    }

    @Override
    protected List<RequestedGlobalProperties> createPossibleGlobalProperties() {
        return Collections.singletonList(new RequestedGlobalProperties());
    }

    @Override
    protected List<RequestedLocalProperties> createPossibleLocalProperties() {
        return Collections.singletonList(new RequestedLocalProperties());
    }

    @Override
    public GlobalProperties computeGlobalProperties(GlobalProperties gProps) {
        if (gProps.getUniqueFieldCombination() != null && gProps.getUniqueFieldCombination().size() > 0 && gProps.getPartitioning() == PartitioningProperty.RANDOM) {
            gProps.setAnyPartitioning(gProps.getUniqueFieldCombination().iterator().next().toFieldList());
        }
        gProps.clearUniqueFieldCombinations();
        return gProps;
    }

    @Override
    public LocalProperties computeLocalProperties(LocalProperties lProps) {
        return lProps.clearUniqueFieldSets();
    }
}

