/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.compiler.postpass;

import org.apache.flink.api.common.operators.DualInputOperator;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.RecordOperator;
import org.apache.flink.api.common.operators.SingleInputOperator;
import org.apache.flink.api.common.operators.base.CoGroupOperatorBase;
import org.apache.flink.api.common.operators.base.GroupReduceOperatorBase;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.api.common.typeutils.record.RecordComparatorFactory;
import org.apache.flink.api.common.typeutils.record.RecordPairComparatorFactory;
import org.apache.flink.api.common.typeutils.record.RecordSerializerFactory;
import org.apache.flink.compiler.CompilerException;
import org.apache.flink.compiler.CompilerPostPassException;
import org.apache.flink.compiler.plan.DualInputPlanNode;
import org.apache.flink.compiler.plan.SingleInputPlanNode;
import org.apache.flink.compiler.plan.SinkPlanNode;
import org.apache.flink.compiler.postpass.ConflictingFieldTypeInfoException;
import org.apache.flink.compiler.postpass.GenericFlatTypePostPass;
import org.apache.flink.compiler.postpass.MissingFieldTypeInfoException;
import org.apache.flink.compiler.postpass.PostPassUtils;
import org.apache.flink.compiler.postpass.SparseKeySchema;
import org.apache.flink.types.Key;

public class RecordModelPostPass
extends GenericFlatTypePostPass<Class<? extends Key<?>>, SparseKeySchema> {
    @Override
    protected SparseKeySchema createEmptySchema() {
        return new SparseKeySchema();
    }

    @Override
    protected void getSinkSchema(SinkPlanNode sinkPlanNode, SparseKeySchema schema) throws CompilerPostPassException {
        GenericDataSinkBase<?> sink = sinkPlanNode.getSinkNode().getPactContract();
        Ordering partitioning = sink.getPartitionOrdering();
        Ordering sorting = sink.getLocalOrder();
        try {
            if (partitioning != null) {
                this.addOrderingToSchema(partitioning, schema);
            }
            if (sorting != null) {
                this.addOrderingToSchema(sorting, schema);
            }
        }
        catch (ConflictingFieldTypeInfoException ex) {
            throw new CompilerPostPassException("Conflicting information found when adding data sink types. Probable reason is contradicting type infos for partitioning and sorting ordering.");
        }
    }

    @Override
    protected void getSingleInputNodeSchema(SingleInputPlanNode node, SparseKeySchema schema) throws CompilerPostPassException, ConflictingFieldTypeInfoException {
        Ordering groupOrder;
        SingleInputOperator<?, ?, ?> contract = node.getSingleInputNode().getPactContract();
        if (!(contract instanceof RecordOperator)) {
            throw new CompilerPostPassException("Error: Operator is not a Record based contract. Wrong compiler invokation.");
        }
        RecordOperator recContract = (RecordOperator)contract;
        int[] localPositions = contract.getKeyColumns(0);
        Class[] types = recContract.getKeyClasses();
        for (int i = 0; i < localPositions.length; ++i) {
            schema.addType(localPositions[i], types[i]);
        }
        if (contract instanceof GroupReduceOperatorBase && (groupOrder = ((GroupReduceOperatorBase)contract).getGroupOrder()) != null) {
            this.addOrderingToSchema(groupOrder, schema);
        }
    }

    @Override
    protected void getDualInputNodeSchema(DualInputPlanNode node, SparseKeySchema input1Schema, SparseKeySchema input2Schema) throws CompilerPostPassException, ConflictingFieldTypeInfoException {
        int i;
        DualInputOperator<?, ?, ?, ?> contract = node.getTwoInputNode().getPactContract();
        if (!(contract instanceof RecordOperator)) {
            throw new CompilerPostPassException("Error: Operator is not a Pact Record based contract. Wrong compiler invokation.");
        }
        RecordOperator recContract = (RecordOperator)contract;
        int[] localPositions1 = contract.getKeyColumns(0);
        int[] localPositions2 = contract.getKeyColumns(1);
        Class[] types = recContract.getKeyClasses();
        if (localPositions1.length != localPositions2.length) {
            throw new CompilerException("Error: The keys for the first and second input have a different number of fields.");
        }
        for (i = 0; i < localPositions1.length; ++i) {
            input1Schema.addType(localPositions1[i], types[i]);
        }
        for (i = 0; i < localPositions2.length; ++i) {
            input2Schema.addType(localPositions2[i], types[i]);
        }
        if (contract instanceof CoGroupOperatorBase) {
            Ordering groupOrder1 = ((CoGroupOperatorBase)contract).getGroupOrderForInputOne();
            Ordering groupOrder2 = ((CoGroupOperatorBase)contract).getGroupOrderForInputTwo();
            if (groupOrder1 != null) {
                this.addOrderingToSchema(groupOrder1, input1Schema);
            }
            if (groupOrder2 != null) {
                this.addOrderingToSchema(groupOrder2, input2Schema);
            }
        }
    }

    private void addOrderingToSchema(Ordering o, SparseKeySchema schema) throws ConflictingFieldTypeInfoException {
        for (int i = 0; i < o.getNumberOfFields(); ++i) {
            Integer pos = o.getFieldNumber(i);
            Class type = o.getType(i);
            schema.addType((int)pos, type);
        }
    }

    @Override
    protected TypeSerializerFactory<?> createSerializer(SparseKeySchema schema) {
        return RecordSerializerFactory.get();
    }

    protected RecordComparatorFactory createComparator(FieldList fields, boolean[] directions, SparseKeySchema schema) throws MissingFieldTypeInfoException {
        int[] positions = fields.toArray();
        Class[] keyTypes = PostPassUtils.getKeys(schema, positions);
        return new RecordComparatorFactory(positions, keyTypes, directions);
    }

    protected RecordPairComparatorFactory createPairComparator(FieldList fields1, FieldList fields2, boolean[] sortDirections, SparseKeySchema schema1, SparseKeySchema schema2) {
        return RecordPairComparatorFactory.get();
    }
}

