/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.flume.ChannelException;
import org.apache.flume.Context;
import org.apache.flume.CounterGroup;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.PollableSource;
import org.apache.flume.conf.Configurable;
import org.apache.flume.event.EventBuilder;
import org.apache.flume.source.AbstractSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StressSource
extends AbstractSource
implements Configurable,
PollableSource {
    private static final Logger logger = LoggerFactory.getLogger(StressSource.class);
    private CounterGroup counterGroup = new CounterGroup();
    private byte[] buffer;
    private long maxTotalEvents;
    private long maxSuccessfulEvents;
    private int batchSize;
    private long lastSent = 0L;
    private Event event;
    private List<Event> eventBatchList;
    private List<Event> eventBatchListToProcess;

    @Override
    public void configure(Context context) {
        this.maxTotalEvents = context.getLong("maxTotalEvents", Long.valueOf(-1L));
        this.maxSuccessfulEvents = context.getLong("maxSuccessfulEvents", Long.valueOf(-1L));
        this.batchSize = context.getInteger("batchSize", Integer.valueOf(1));
        int size = context.getInteger("size", Integer.valueOf(500));
        this.prepEventData(size);
    }

    private void prepEventData(int bufferSize) {
        this.buffer = new byte[bufferSize];
        Arrays.fill(this.buffer, (byte)127);
        if (this.batchSize > 1) {
            this.eventBatchList = new ArrayList<Event>();
            for (int i = 0; i < this.batchSize; ++i) {
                this.eventBatchList.add(EventBuilder.withBody((byte[])this.buffer));
            }
        } else {
            this.event = EventBuilder.withBody((byte[])this.buffer);
        }
    }

    @Override
    public PollableSource.Status process() throws EventDeliveryException {
        long totalEventSent = this.counterGroup.addAndGet("events.total", this.lastSent);
        if (this.maxTotalEvents >= 0L && totalEventSent >= this.maxTotalEvents || this.maxSuccessfulEvents >= 0L && this.counterGroup.get("events.successful") >= this.maxSuccessfulEvents) {
            return PollableSource.Status.BACKOFF;
        }
        try {
            this.lastSent = this.batchSize;
            if (this.batchSize == 1) {
                this.getChannelProcessor().processEvent(this.event);
            } else {
                long eventsLeft = this.maxTotalEvents - totalEventSent;
                this.eventBatchListToProcess = this.maxTotalEvents >= 0L && eventsLeft < (long)this.batchSize ? this.eventBatchList.subList(0, (int)eventsLeft) : this.eventBatchList;
                this.lastSent = this.eventBatchListToProcess.size();
                this.getChannelProcessor().processEventBatch(this.eventBatchListToProcess);
            }
            this.counterGroup.addAndGet("events.successful", this.lastSent);
        }
        catch (ChannelException ex) {
            this.counterGroup.addAndGet("events.failed", this.lastSent);
            return PollableSource.Status.BACKOFF;
        }
        return PollableSource.Status.READY;
    }

    @Override
    public void start() {
        logger.info("Stress source starting");
        super.start();
        logger.debug("Stress source started");
    }

    @Override
    public void stop() {
        logger.info("Stress source stopping");
        super.stop();
        logger.info("Stress source stopped. Metrics:{}", (Object)this.counterGroup);
    }
}

