/**
 * @file
 * @brief Tests for normal case.
 *
 * These are tests for normal case of @asprintf and @vasprintf.
 */

#include <stdlib.h>
#include <cutter.h>

#include "asprintf.h"

/**
 * @brief Test for normal case, no argument in variable argument list.
 *
 * This is a test for normal case, no argument in variable argument list.
 */
void test_normal_case_0_arg(void)
{
    char *str;
    int size = asprintf(&str, "ABCDEFG");
    cut_assert_equal_int(7, size);
    cut_assert_equal_string("ABCDEFG", str);
    free(str);
}

/**
 * @brief Test for normal case, one argument in variable argument list.
 *
 * This is a test for normal case, one argument in variable argument list.
 */
void test_normal_case_1_arg(void)
{
    char *str;
    int size = asprintf(&str, "%s", "ABCDEFG");
    cut_assert_equal_int(7, size);
    cut_assert_equal_string("ABCDEFG", str);
    free(str);
}

/**
 * @brief Test for normal case, two arguments in variable argument list.
 *
 * This is a test for normal case, two arguments in variable argument list.
 */
void test_normal_case_2_args(void)
{
    char *str;
    int size = asprintf(&str, "%s%s", "ABCDEFG", "HIJKLMN");
    cut_assert_equal_int(14, size);
    cut_assert_equal_string("ABCDEFGHIJKLMN", str);
    free(str);
}
