/**
 * @file
 * @brief Test for first @vsnprintf call parameter check case.
 *
 * This is test for first @vsnprintf call parameter check case of @asprintf
 * and @vasprintf.
 */

#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <cutter.h>

#include "asprintf.h"

static char *vsnprintf1_str;
static size_t vsnprintf1_size;
static const char *vsnprintf1_format;
static int vsnprintf1_arg1;
static int vsnprintf1_arg2;

static int mock_vsnprintf1(
    char * restrict str, size_t size,
    const char * restrict format, va_list ap)
{
    vsnprintf1_str = str;
    vsnprintf1_size = size;
    vsnprintf1_format = format;
    vsnprintf1_arg1 = va_arg(ap, int);
    vsnprintf1_arg2 = va_arg(ap, int);
    return -1;
}

/**
 * @brief Setup for first @vsnprintf call parameter check case.
 *
 * This is a setup function for first @vsnprintf call parameter check case.
 *
 * This function sets @c mockable_vsnprintf1 to be mock function
 * @c mock_vsnprintf1, and resets all save area.
 *
 * The mock function @c mock_vsnprintf1 saves its parameters, and returns
 * @c -1.
 */
void cut_setup(void)
{
    mockable_vsnprintf1 = mock_vsnprintf1;
    vsnprintf1_str = "";
    vsnprintf1_size = 1;
    vsnprintf1_format = "";
    vsnprintf1_arg1 = 0;
    vsnprintf1_arg2 = 0;
}

/**
 * @brief Teardown for first @vsnprintf call parameter check case.
 *
 * This is a teardown function for first @vsnprintf call parameter check case.
 *
 * This function resets @c mockable_vsnprintf1.
 */
void cut_teardown(void)
{
    mockable_vsnprintf1 = vsnprintf;
}

/**
 * @brief Test for first @vsnprintf call parameter check case.
 *
 * This is a test for first @vsnprintf call parameter check case.
 */
void test_vsnprintf1_parameter_check_case(void)
{
    char *str;
    const char *format = "%d %d";
    int arg1 = 123;
    int arg2 = 456;
    asprintf(&str, format, arg1, arg2);
    cut_assert_null(vsnprintf1_str);
    cut_assert_equal_size(0, vsnprintf1_size);
    cut_assert_equal_pointer(format, vsnprintf1_format);
    cut_assert_equal_int(arg1, vsnprintf1_arg1);
    cut_assert_equal_int(arg2, vsnprintf1_arg2);
    free(str);
}
