/*
 * Decompiled with CFR 0.152.
 */
package saccubus;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JLabel;
import saccubus.ConvertStopFlag;
import saccubus.Converter;
import saccubus.ConvertingSetting;
import saccubus.WayBackDate;
import saccubus.net.Path;
import saccubus.util.DuplicatedOutput;

public class Prompt {
    private static final String LOGFILE = ".\\log.txt";
    private static final String LOGFILE2 = ".\\sacclog.txt";
    private static DuplicatedOutput dout = null;
    private static String logname = ".\\log.txt";
    private static int maxsize = 1000000;
    private static boolean enablePupup = false;
    private static HashMap<String, String> settingMap = new HashMap(16);
    private static HashMap<String, String> optionMap = new HashMap(16);
    private static HashMap<String, String> downloadMap = new HashMap(16);
    private static String optionFilePrefix = "";
    private static ConvertingSetting setting;
    private static String propFile;
    private static String addPropFile;
    private static Properties prop;

    static {
        propFile = ConvertingSetting.PROP_FILE;
        addPropFile = "";
    }

    public static void main(String[] args) {
        if (!Prompt.setLog(logname) && !Prompt.setLog(LOGFILE2)) {
            Prompt.exit(1);
        }
        System.out.println(WayBackDate.formatNow());
        if (args.length < 3) {
            System.out.println("Error. MailAddress, Password, VideoID must be specified.");
            Prompt.exit(2);
        }
        String mail = "";
        String pass = "";
        String tag = "";
        String time = "";
        ArrayList<String> atArgs = new ArrayList<String>();
        int i = 0;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.startsWith("@") || i > 3) {
                atArgs.add(arg);
            } else {
                switch (i) {
                    case 0: {
                        mail = arg;
                        ++i;
                        break;
                    }
                    case 1: {
                        pass = arg;
                        ++i;
                        break;
                    }
                    case 2: {
                        tag = arg;
                        ++i;
                        break;
                    }
                    case 3: {
                        time = arg;
                        ++i;
                    }
                }
            }
            ++n2;
        }
        if (mail.isEmpty() || pass.isEmpty() || tag.isEmpty()) {
            System.out.println("Error. MailAddress, Password, VideoID must be specified.");
            Prompt.exit(2);
        }
        for (String string : atArgs) {
            if (string == null || string.isEmpty()) continue;
            if (string.startsWith("#") || string.startsWith("//")) break;
            if (string.equals("@NDL")) {
                downloadMap.put("SaveVideoFile", "false");
                downloadMap.put("SaveCommentFile", "false");
                System.out.println("Set No Download.");
                continue;
            }
            if (string.equals("@DLO")) {
                downloadMap.put("SaveVideoFile", "true");
                downloadMap.put("SaveCommentFile", "true");
                downloadMap.put("SaveConvertedFile", "false");
                System.out.println("Set Download Only.");
                continue;
            }
            if (string.equals("@DLC")) {
                downloadMap.put("SaveCommentFile", "true");
                downloadMap.put("SaveConvertedFile", "false");
                System.out.println("Set Download Comment Only.");
                continue;
            }
            if (string.equals("@PUP")) {
                enablePupup = true;
                continue;
            }
            if (string.startsWith("@SET=")) {
                propFile = string.substring(string.indexOf(61) + 1);
                System.out.println("Set Setting Property File:" + propFile + ".");
                continue;
            }
            if (string.startsWith("@ADD=")) {
                addPropFile = string.substring(string.indexOf(61) + 1);
                System.out.println("Set Adding Property File:" + addPropFile + ".");
                continue;
            }
            if (string.startsWith("-") && string.contains("=")) {
                int index = string.indexOf(61);
                String key = string.substring(0, index);
                String value = string.substring(index + 1);
                optionMap.put(key, value);
                continue;
            }
            if (string.contains("=")) {
                int index = string.indexOf(61);
                String key = string.substring(0, index);
                String value = string.substring(index + 1);
                settingMap.put(key, value);
                continue;
            }
            if (string.contains(":")) {
                if (!time.contains("/")) continue;
                time = String.valueOf(time.trim()) + " " + string.trim();
                continue;
            }
            if (optionFilePrefix.isEmpty() && Character.isLetter(string.charAt(0))) {
                optionFilePrefix = string.trim();
                continue;
            }
            System.out.println("Undefined Argument: <" + string + ">");
        }
        prop = ConvertingSetting.loadProperty(propFile, true);
        if (!optionFilePrefix.isEmpty()) {
            prop.setProperty("OptionFile", String.valueOf(optionFilePrefix) + "OptionFile");
            prop.setProperty("WideOptionFile", String.valueOf(optionFilePrefix) + "WideOptionFile");
            prop.setProperty("QOptionFile", String.valueOf(optionFilePrefix) + "QOptionFile");
        }
        for (Map.Entry entry : settingMap.entrySet()) {
            prop.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : downloadMap.entrySet()) {
            prop.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        setting = ConvertingSetting.loadSetting(mail, pass, prop);
        if (!addPropFile.isEmpty()) {
            ConvertingSetting.addSetting(setting, addPropFile);
        }
        if (!optionMap.isEmpty()) {
            setting.setReplaceOptions(optionMap);
        }
        JLabel jLabel = new JLabel();
        JLabel info = new JLabel();
        JLabel watch = new JLabel();
        JButton stopButton = new JButton();
        final ConvertStopFlag cuiStop = new ConvertStopFlag(stopButton, "\u505c\u6b62", "\u5f85\u6a5f", "\u7d42\u4e86");
        stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cuiStop.stop();
            }
        });
        Window popup = new Window(null);
        popup.setSize(360, 20);
        popup.setLocation(0, 0);
        popup.setLayout(new BorderLayout(5, 0));
        Color fg = Color.black;
        Color bg = Color.lightGray;
        popup.setForeground(fg);
        popup.setBackground(bg);
        stopButton.setForeground(fg);
        stopButton.setBackground(bg);
        stopButton.setSize(25, 15);
        stopButton.setBounds(0, 0, 25, 15);
        stopButton.setVisible(true);
        jLabel.setForeground(fg);
        jLabel.setBackground(bg);
        jLabel.setVisible(true);
        popup.add((Component)stopButton, "West");
        popup.add((Component)jLabel, "Center");
        popup.setVisible(enablePupup);
        StringBuffer sbReturn = new StringBuffer(16);
        Converter conv = new Converter(tag, time, setting, jLabel, cuiStop, info, watch, sbReturn);
        System.out.println("-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-");
        System.out.println("Saccubus on CUI");
        System.out.println();
        System.out.println("-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-");
        System.out.println("Mailaddr: " + mail);
        System.out.println("Password: hidden");
        System.out.println("VideoID: " + tag);
        System.out.println("WaybackTime: " + time);
        if (!optionFilePrefix.isEmpty()) {
            System.out.println("OptionPrefix: " + optionFilePrefix);
        }
        if (!atArgs.isEmpty()) {
            System.out.print("Other args:");
            for (String arg : atArgs) {
                System.out.print(" " + arg);
            }
            System.out.println();
        }
        System.out.println("-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-");
        System.out.println("Version 1.62.0.2");
        conv.start();
        try {
            conv.join();
        }
        catch (InterruptedException arg) {
            // empty catch block
        }
        popup.dispose();
        System.out.println("Finished.");
        System.out.println();
        String[] ret = sbReturn.toString().split("\n");
        int code = 0;
        int l = 0;
        while (l < ret.length) {
            System.out.println(ret[l]);
            String[] s = ret[l].split("=");
            if ("RESULT".equals(s[0]) && !"0".equals(s[1])) {
                code = Integer.parseInt(s[1], 16);
            }
            ++l;
        }
        Prompt.exit(code);
    }

    private static int getLogsize() {
        String logsize = System.getenv("logsize");
        if (logsize != null && !logsize.isEmpty()) {
            return Prompt.decode(logsize);
        }
        return maxsize;
    }

    private static int decode(String str) {
        if (str == null || str.isEmpty()) {
            return maxsize;
        }
        str = str.toLowerCase();
        int value = 1;
        int len = str.length();
        char suffix = str.charAt(len - 1);
        if (suffix == 'k') {
            value = 1000;
            str = str.substring(0, len - 1);
        } else if (suffix == 'm') {
            value = 1000000;
            str = str.substring(0, len - 1);
        }
        try {
            value *= Integer.decode(str).intValue();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            value = maxsize;
        }
        return value;
    }

    private static void exit(int status) {
        if (dout != null) {
            dout.flush();
            dout.close();
        }
        System.exit(status);
    }

    private static boolean setLog(String path) {
        String text;
        int len;
        File log = new File(path);
        if (log.exists() && log.canRead() && (len = (text = Path.readAllText(path, "MS932")).length()) > Prompt.getLogsize()) {
            text = text.substring(len - Prompt.getLogsize());
            if (log.delete()) {
                try {
                    PrintStream ps = new PrintStream(log);
                    ps.print(text);
                    ps.flush();
                    ps.close();
                    dout = new DuplicatedOutput(log);
                    System.setErr(dout.dup(System.err));
                    System.setOut(dout.dup(System.out));
                    return true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }
        if (!log.exists() || log.canWrite()) {
            try {
                dout = new DuplicatedOutput(log);
                System.setErr(dout.dup(System.err));
                System.setOut(dout.dup(System.out));
                return true;
            }
            catch (IOException e1) {
                e1.printStackTrace();
                return false;
            }
        }
        return true;
    }
}

