/*
 * Decompiled with CFR 0.152.
 */
package saccubus.net;

import java.io.File;
import saccubus.ConvertingSetting;
import saccubus.net.Path;

public class BrowserInfo {
    private BrowserCookieKind validBrowser = BrowserCookieKind.NONE;
    private static final BrowserCookieKind[] ALL_BROWSER = BrowserCookieKind.values();
    public static final int NUM_BROWSER = ALL_BROWSER.length;

    public String getUserSession(ConvertingSetting setting) {
        String user_session = "";
        if (setting == null) {
            return user_session;
        }
        BrowserCookieKind[] browserCookieKindArray = ALL_BROWSER;
        int n = ALL_BROWSER.length;
        int n2 = 0;
        while (n2 < n) {
            BrowserCookieKind browser = browserCookieKindArray[n2];
            switch (browser) {
                case MSIE: {
                    if (!setting.isBrowser(browser)) break;
                    user_session = this.getUserSession(browser);
                    break;
                }
                case Firefox: 
                case Chrome: 
                case Opera: 
                case Chromium: {
                    if (!user_session.isEmpty() || !setting.isBrowser(browser)) break;
                    user_session = this.getUserSession(browser);
                    break;
                }
                case Other: {
                    if (!user_session.isEmpty() || !setting.isBrowserOther()) break;
                    user_session = this.getUserSessionOther(setting.getBrowserCookiePath());
                    break;
                }
            }
            ++n2;
        }
        return user_session;
    }

    public BrowserCookieKind getValidBrowser() {
        return this.validBrowser;
    }

    public String getUserSession(BrowserCookieKind browserKind) {
        String user_session = "";
        switch (browserKind) {
            case MSIE: {
                user_session = this.getUserSessionFromMSIE();
                break;
            }
            case Firefox: {
                user_session = this.getUserSessionFromFilefox4();
                if (!user_session.isEmpty()) break;
                user_session = this.getUserSessionFromFilefox3();
                break;
            }
            case Chrome: {
                user_session = this.getUserSesionChrome();
                break;
            }
            case Chromium: {
                user_session = this.getUserSesionChromium();
                break;
            }
            case Opera: {
                user_session = this.getUserSessionOpera();
                break;
            }
        }
        if (!user_session.isEmpty()) {
            this.validBrowser = browserKind;
        }
        return user_session;
    }

    public String getUserSessionOther(String fileOrDir) {
        String user_session = "";
        try {
            if (Path.isDirectory(fileOrDir)) {
                String string = user_session = this.getUserSessionFromDirectory(fileOrDir);
                return string;
            }
            if (Path.isFile(fileOrDir)) {
                String dataStr = Path.readAllText(fileOrDir, "UTF-8");
                String string = user_session = this.cutUserSession(dataStr, fileOrDir);
                return string;
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        finally {
            if (!user_session.isEmpty()) {
                this.validBrowser = BrowserCookieKind.Other;
            }
        }
    }

    private String getUserSessionFromFilefox3() {
        String sqlist_filename;
        String user_session;
        block5: {
            String app_dir;
            block4: {
                user_session = "";
                try {
                    app_dir = System.getenv("APPDATA");
                    if (app_dir != null && !app_dir.isEmpty()) break block4;
                    return "";
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return user_session;
                }
            }
            sqlist_filename = String.valueOf(app_dir) + "\\Mozilla\\Firefox\\Profiles\\cookies.sqlite";
            if (Path.isFile(sqlist_filename)) break block5;
            return "";
        }
        String dataStr = Path.readAllText(sqlist_filename, "US-ASCII");
        user_session = this.cutUserSession(dataStr, sqlist_filename);
        return user_session;
    }

    private String getUserSessionFromFilefox4() {
        String[] userLists;
        String user_session;
        block7: {
            String app_dir;
            block6: {
                user_session = "";
                app_dir = System.getenv("APPDATA");
                if (app_dir != null && !app_dir.isEmpty()) break block6;
                return "";
            }
            userLists = Path.getFullnameList(String.valueOf(app_dir) + "\\Mozilla\\Firefox\\Profiles\\");
            if (userLists != null) break block7;
            return "";
        }
        try {
            String[] stringArray = userLists;
            int n = userLists.length;
            int n2 = 0;
            while (n2 < n) {
                String dataStr;
                String user_dir = stringArray[n2];
                String sqlist_filename = String.valueOf(user_dir) + "\\cookies.sqlite";
                if (Path.isFile(sqlist_filename) && !(user_session = this.cutUserSession(dataStr = Path.readAllText(sqlist_filename, "US-ASCII"), sqlist_filename)).isEmpty()) {
                    return user_session;
                }
                ++n2;
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private String getUserSessionFromMSIE() {
        String user_session = " ";
        StringBuffer sb = new StringBuffer();
        String profile_dir = null;
        String WINDOWS_DIR = "\\Microsoft\\Windows";
        profile_dir = System.getenv("APPDATA");
        if (profile_dir != null && !profile_dir.isEmpty() && !(user_session = this.getUserSessionFromMSIE(String.valueOf(profile_dir) + "\\Microsoft\\Windows")).isEmpty()) {
            sb.append(String.valueOf(user_session) + " ");
        }
        if ((profile_dir = System.getenv("LOCALAPPDATA")) != null && !profile_dir.isEmpty() && !(user_session = this.getUserSessionFromMSIE(String.valueOf(profile_dir) + "\\Microsoft\\Windows")).isEmpty()) {
            sb.append(String.valueOf(user_session) + " ");
        }
        if ((profile_dir = System.getenv("PROFILE")) != null && !profile_dir.isEmpty() && !(user_session = this.getUserSessionFromMSIE(profile_dir)).isEmpty()) {
            sb.append(String.valueOf(user_session) + " ");
        }
        if ((profile_dir = System.getenv("USERPROFILE")) != null && !profile_dir.isEmpty() && !(user_session = this.getUserSessionFromMSIE(profile_dir)).isEmpty()) {
            sb.append(String.valueOf(user_session) + " ");
        }
        user_session = sb.substring(0).trim();
        return user_session;
    }

    private String getUserSessionFromMSIE(String folder) {
        String COOKIE_DIR = "\\Cookies";
        String COOKIE_DIR2 = "\\InetCookies";
        String user_session = "";
        StringBuilder sb1 = new StringBuilder();
        if (folder == null || folder.isEmpty()) {
            return "";
        }
        user_session = this.getUserSessionFromMSIE2(String.valueOf(folder) + "\\Cookies");
        if (!user_session.isEmpty()) {
            sb1.append(String.valueOf(user_session) + " ");
        }
        if (!(user_session = this.getUserSessionFromMSIE2(String.valueOf(folder) + "\\InetCookies")).isEmpty()) {
            sb1.append(String.valueOf(user_session) + " ");
        }
        user_session = sb1.substring(0).trim();
        return user_session;
    }

    private String getUserSessionFromMSIE2(String folder) {
        String user_session = null;
        StringBuilder sb2 = new StringBuilder();
        user_session = this.getUserSessionFromDirectory(String.valueOf(folder) + "\\");
        if (!user_session.isEmpty()) {
            sb2.append(String.valueOf(user_session) + " ");
        }
        if (!(user_session = this.getUserSessionFromDirectory(String.valueOf(folder) + "\\Low\\")).isEmpty()) {
            sb2.append(String.valueOf(user_session) + " ");
        }
        user_session = sb2.substring(0).trim();
        return user_session;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getUserSessionFromDirectory(String dir_name) {
        String user_session = "";
        try {
            if (!Path.isDirectory(dir_name)) return "";
            String[] files = Path.getFullnameList(dir_name);
            if (files == null) {
                return "";
            }
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return "";
                }
                String fullname = stringArray[n2];
                File file = null;
                try {
                    file = new File(fullname);
                }
                catch (Exception e) {
                    return "";
                }
                if (file == null) {
                    return "";
                }
                user_session = this.cutUserSession(Path.readAllText(fullname, "MS932"), fullname);
                if (!user_session.isEmpty()) {
                    return user_session;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    private String getUserSesionChrome() {
        String user_session = "";
        String cookie_file = "";
        String googleChrome = "\\Google\\Chrome\\User Data\\Default\\Cookies";
        try {
            String dataStr;
            String local_Appdir = System.getenv("LOCALAPPDATA");
            if (local_Appdir != null && !local_Appdir.isEmpty() && Path.isFile(cookie_file = String.valueOf(local_Appdir) + googleChrome) && !(user_session = this.cutUserSession(dataStr = Path.readAllText(cookie_file, "UTF-8"), cookie_file)).isEmpty()) {
                return user_session;
            }
            String profile_dir = System.getenv("USERPROFILE");
            if (profile_dir != null && !profile_dir.isEmpty() && Path.isFile(cookie_file = String.valueOf(profile_dir) + "\\Local Settings\\Application Data" + googleChrome)) {
                String dataStr2 = Path.readAllText(cookie_file, "UTF-8");
                user_session = this.cutUserSession(dataStr2, cookie_file);
                return user_session;
            }
            String app_dir = System.getenv("APPDATA");
            if (app_dir != null && !app_dir.isEmpty() && Path.isFile(cookie_file = String.valueOf(app_dir) + googleChrome)) {
                String dataStr3 = Path.readAllText(cookie_file, "UTF-8");
                user_session = this.cutUserSession(dataStr3, cookie_file);
                return user_session;
            }
            return user_session;
        }
        catch (Exception e) {
            e.printStackTrace();
            return user_session;
        }
    }

    private String getUserSesionChromium() {
        String user_session = "";
        String cookie_file = "";
        String chromium = "\\Chromium\\User Data\\Default\\Cookies";
        try {
            String local_Appdir = System.getenv("LOCALAPPDATA");
            if (local_Appdir != null && !local_Appdir.isEmpty() && Path.isFile(cookie_file = String.valueOf(local_Appdir) + chromium)) {
                String dataStr = Path.readAllText(cookie_file, "UTF-8");
                user_session = this.cutUserSession(dataStr, cookie_file);
                return user_session;
            }
            String profile_dir = System.getenv("USERPROFILE");
            if (profile_dir != null && !profile_dir.isEmpty() && Path.isFile(cookie_file = String.valueOf(profile_dir) + "\\Local Settings\\Application Data" + chromium)) {
                String dataStr = Path.readAllText(cookie_file, "UTF-8");
                user_session = this.cutUserSession(dataStr, cookie_file);
                return user_session;
            }
            return user_session;
        }
        catch (Exception e) {
            e.printStackTrace();
            return user_session;
        }
    }

    private String getUserSessionOpera() {
        String user_session = "";
        String cookie_file = "";
        try {
            String app_dir = System.getenv("APPDATA");
            if (app_dir != null && !app_dir.isEmpty() && Path.isFile(cookie_file = String.valueOf(app_dir) + "\\Opera\\Opera\\cookies4.dat")) {
                String dataStr = Path.readAllText(cookie_file, "UTF-8");
                user_session = this.cutUserSession(dataStr, cookie_file);
                return user_session;
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private String cutUserSession(String str, String filename) {
        String ret = "";
        StringBuffer sb = new StringBuffer("");
        int start = str.indexOf("user_session_");
        while (start >= 0) {
            int index = start + "user_session_".length();
            while (index < str.length() && ('0' <= str.charAt(index) && str.charAt(index) <= '9' || 'a' <= str.charAt(index) && str.charAt(index) <= 'z' || str.charAt(index) == '_')) {
                ++index;
            }
            ret = str.substring(start, index);
            start = str.indexOf("user_session_", index);
            if (ret.isEmpty() || filename.isEmpty()) continue;
            System.out.println("Cookie found: " + filename);
            sb.append(String.valueOf(ret) + " ");
        }
        return sb.toString();
    }

    public static enum BrowserCookieKind {
        NONE{

            @Override
            public String getName() {
                return "\u3055\u304d\u3085\u3070\u3059";
            }
        }
        ,
        MSIE{

            @Override
            public String getName() {
                return "Internet Exploror";
            }
        }
        ,
        Firefox,
        Chrome,
        Opera,
        Chromium,
        Other;


        public String getName() {
            return this.name();
        }
    }
}

