/*
 * Decompiled with CFR 0.152.
 */
package saccubus.util;

import java.util.Date;
import javax.swing.JLabel;

public class Stopwatch {
    private Date startedDate = new Date();
    private Date stopedDate = new Date();
    private final JLabel out;
    private static String FMT1 = "%d\u79d2%03d\u30df\u30ea";
    private static String FMT2 = "%d\u5206%02d\u79d2%03d\u30df\u30ea";
    private static String FMT3 = "%d\u6642\u9593%02d\u5206%02d\u79d2%03d\u30df\u30ea";
    private static long LONG_SEC = 1000L;
    private static long LONG_MINUIT = 60L * LONG_SEC;
    private static long LONG_HOUR = 60L * LONG_MINUIT;

    public synchronized void start() {
        this.startedDate = new Date();
    }

    public synchronized void stop() {
        this.stopedDate = new Date();
    }

    public Stopwatch(JLabel out) {
        this.out = out;
    }

    public static void setup(JLabel display) {
    }

    private boolean isSetup() {
        return this.out != null;
    }

    public JLabel getSource() {
        return this.out;
    }

    public synchronized void clear() {
        if (this.isSetup()) {
            this.out.setText(" ");
        }
    }

    private long getStartTime() {
        return this.startedDate.getTime();
    }

    private long getStopTime() {
        return this.stopedDate.getTime();
    }

    private long getElapsedTime() {
        return new Date().getTime() - this.getStartTime();
    }

    private static String format(long time) {
        if (time < 0L) {
            return "";
        }
        if (time < LONG_MINUIT) {
            long s = time / LONG_SEC;
            return String.format(FMT1, s, time %= LONG_SEC);
        }
        if (time < LONG_HOUR) {
            long m = time / LONG_MINUIT;
            long s = (time %= LONG_MINUIT) / LONG_SEC;
            return String.format(FMT2, m, s, time %= LONG_SEC);
        }
        long h = time / LONG_HOUR;
        long m = (time %= LONG_HOUR) / LONG_MINUIT;
        long s = (time %= LONG_MINUIT) / LONG_SEC;
        return String.format(FMT3, h, m, s, time %= LONG_SEC);
    }

    public String formatElapsedTime() {
        return Stopwatch.format(this.getElapsedTime());
    }

    public void show() {
        if (this.isSetup()) {
            this.out.setText("\u7d4c\u904e\u6642\u9593\u3000" + this.formatElapsedTime());
        }
    }

    public String formatLatency() {
        return Stopwatch.format(this.getStopTime() - this.getStartTime());
    }
}

