/*
 * Decompiled with CFR 0.152.
 */
package miragecrops6.crop;

import ic2.api.crops.CropCard;
import ic2.api.crops.ICropTile;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import miragecrops6.crop.CropCardMirageCrops;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class HCropCardMirageCrops {
    public static final int COLLISION = 1;
    public static final int LEFT_CLICK = 2;
    public static final int RIGHT_CLICK = 4;
    public static final int CLICK = 6;
    protected static final DamageSource DAMAGESOURCE = new DamageSource("Sarracenia");

    public static void setGain(CropCardMirageCrops cropCard, Function<ICropTile, ItemStack> function) {
        HCropCardMirageCrops.setGain(cropCard, HCropCardMirageCrops.array(cropCard.maxSize()), function);
    }

    public static void setTextureRespect(CropCardMirageCrops cropCard, int[] sizes, CropCardMirageCrops target) {
        IntFunction<String> old = cropCard.lambda_getSpriteName;
        cropCard.lambda_getSpriteName = n -> {
            if (HCropCardMirageCrops.contains(sizes, n)) {
                return target.getSpriteName(n);
            }
            return (String)old.apply(n);
        };
    }

    public static void setSizeAfterHarvest(CropCardMirageCrops cropCard, int[] sizes, int after) {
        HCropCardMirageCrops.setSizeAfterHarvest(cropCard, sizes, iCropTile -> after);
    }

    public static void setSizeAfterHarvest(CropCardMirageCrops cropCard, int[] sizes, ToIntFunction<ICropTile> function) {
        ToIntFunction<ICropTile> old = cropCard.lambda_getSizeAfterHarvest;
        cropCard.lambda_getSizeAfterHarvest = iCropTile -> {
            if (HCropCardMirageCrops.contains(sizes, iCropTile.getSize())) {
                return function.applyAsInt((ICropTile)iCropTile);
            }
            return old.applyAsInt((ICropTile)iCropTile);
        };
    }

    public static void setGain(CropCardMirageCrops cropCard, int[] sizes, Function<ICropTile, ItemStack> function) {
        cropCard.lambda_getOptimalHavestSize = iCropTile -> sizes[sizes.length - 1];
        Object old = cropCard.lambda_canBeHarvested;
        cropCard.lambda_canBeHarvested = iCropTile -> {
            if (HCropCardMirageCrops.contains(sizes, iCropTile.getSize())) {
                return true;
            }
            return old.test(iCropTile);
        };
        old = cropCard.lambda_getGain;
        cropCard.lambda_getGain = arg_0 -> HCropCardMirageCrops.lambda$5(sizes, function, (Function)old, arg_0);
    }

    public static void setGrowthDurationRatio(CropCardMirageCrops cropCard, int[] sizes, double ratio) {
        ToIntFunction<ICropTile> old = cropCard.lambda_growthDuration;
        cropCard.lambda_growthDuration = iCropTile -> {
            if (HCropCardMirageCrops.contains(sizes, iCropTile.getSize())) {
                return (int)((double)old.applyAsInt((ICropTile)iCropTile) * ratio);
            }
            return old.applyAsInt((ICropTile)iCropTile);
        };
    }

    public static void setEmittedLight(CropCardMirageCrops cropCard, int[] sizes, int emittedLight) {
        ToIntFunction<ICropTile> old = cropCard.lambda_getEmittedLight;
        cropCard.lambda_getEmittedLight = iCropTile -> {
            if (HCropCardMirageCrops.contains(sizes, iCropTile.getSize())) {
                return emittedLight;
            }
            return old.applyAsInt((ICropTile)iCropTile);
        };
    }

    public static void setGrowthLightRegion(CropCardMirageCrops cropCard, int[] sizes, int min, int max) {
        Predicate<ICropTile> old = cropCard.lambda_canGrow;
        cropCard.lambda_canGrow = iCropTile -> {
            if (HCropCardMirageCrops.contains(sizes, iCropTile.getSize())) {
                if (iCropTile.getLightLevel() < min) {
                    return false;
                }
                if (iCropTile.getLightLevel() > max) {
                    return false;
                }
            }
            return old.test((ICropTile)iCropTile);
        };
    }

    public static void setTickerNagae(CropCardMirageCrops cropCard, int[] sizes) {
        Consumer<ICropTile> old = cropCard.lambda_tick;
        cropCard.lambda_tick = iCropTile -> {
            if (HCropCardMirageCrops.contains(sizes, iCropTile.getSize())) {
                World world = iCropTile.getWorld();
                if ((world.func_72896_J() || world.func_72911_I()) && world.func_72937_j(iCropTile.getLocation().field_71574_a, iCropTile.getLocation().field_71572_b + 1, iCropTile.getLocation().field_71573_c)) {
                    EntityLightningBolt entityLightningBolt = new EntityLightningBolt(world, (double)iCropTile.getLocation().field_71574_a, (double)(iCropTile.getLocation().field_71572_b + 1), (double)iCropTile.getLocation().field_71573_c);
                    world.func_72942_c((Entity)entityLightningBolt);
                    iCropTile.setNutrientStorage(Math.min(100, iCropTile.getNutrientStorage() + 100));
                    iCropTile.setSize((byte)(iCropTile.getSize() + 1));
                    iCropTile.getWorld().func_72926_e(2005, iCropTile.getLocation().field_71574_a, iCropTile.getLocation().field_71572_b, iCropTile.getLocation().field_71573_c, 0);
                }
                old.accept((ICropTile)iCropTile);
            }
        };
    }

    public static void addCropComponent(CropCardMirageCrops cropCard, int size, int timing, BiConsumer<ICropTile, EntityLivingBase> comsumer) {
        HCropCardMirageCrops.addCropComponent(cropCard, new int[]{size}, timing, comsumer);
    }

    public static void addCropComponent(CropCardMirageCrops cropCard, int[] sizes, int timing, BiConsumer<ICropTile, EntityLivingBase> comsumer) {
        BiConsumer<ICropTile, EntityLivingBase> old;
        if ((timing & 1) != 0) {
            old = cropCard.lambda_onCollisionEntityLiving;
            cropCard.lambda_onCollisionEntityLiving = (iCropTile, entityLivingBase) -> {
                if (HCropCardMirageCrops.contains(sizes, iCropTile.getSize())) {
                    comsumer.accept((ICropTile)iCropTile, (EntityLivingBase)entityLivingBase);
                }
                old.accept((ICropTile)iCropTile, (EntityLivingBase)entityLivingBase);
            };
        }
        if ((timing & 2) != 0) {
            old = cropCard.lambda_onLeftClick;
            cropCard.lambda_onLeftClick = (iCropTile, entityPlayer) -> {
                if (HCropCardMirageCrops.contains(sizes, iCropTile.getSize())) {
                    comsumer.accept((ICropTile)iCropTile, (EntityLivingBase)entityPlayer);
                }
                old.accept((ICropTile)iCropTile, (EntityLivingBase)entityPlayer);
            };
        }
        if ((timing & 4) != 0) {
            old = cropCard.lambda_onRightClick;
            cropCard.lambda_onRightClick = (iCropTile, entityPlayer) -> {
                if (HCropCardMirageCrops.contains(sizes, iCropTile.getSize())) {
                    comsumer.accept((ICropTile)iCropTile, (EntityLivingBase)entityPlayer);
                }
                old.accept((ICropTile)iCropTile, (EntityLivingBase)entityPlayer);
            };
        }
    }

    private static boolean contains(int[] sizes, int size) {
        for (int size2 : sizes) {
            if (size2 != size) continue;
            return true;
        }
        return false;
    }

    public static void addCropComponentCactus(CropCardMirageCrops cropCard, int[] sizes, int timing, float damage) {
        HCropCardMirageCrops.addCropComponent(cropCard, sizes, timing, (ICropTile iCropTile, EntityLivingBase entityLivingBase) -> entityLivingBase.func_70097_a(DamageSource.field_76367_g, damage));
    }

    public static void addCropComponentSlow(CropCardMirageCrops cropCard, int[] sizes, int timing) {
        HCropCardMirageCrops.addCropComponent(cropCard, sizes, timing, (ICropTile iCropTile, EntityLivingBase entityLivingBase) -> entityLivingBase.func_70690_d(new PotionEffect(2, 6, 3, true)));
    }

    public static void addCropComponentFire(CropCardMirageCrops cropCard, int[] sizes, int timing, int duration) {
        HCropCardMirageCrops.addCropComponent(cropCard, sizes, timing, (ICropTile iCropTile, EntityLivingBase entityLivingBase) -> entityLivingBase.func_70015_d(duration));
    }

    public static void addCropComponentSarracenia(CropCardMirageCrops cropCard, int[] sizes, int timing, float damage, Predicate<EntityLivingBase> predicateEntityLiving) {
        HCropCardMirageCrops.addCropComponent(cropCard, sizes, timing, (ICropTile iCropTile, EntityLivingBase entityLivingBase) -> {
            if (iCropTile.getNutrientStorage() < 20 && predicateEntityLiving.test((EntityLivingBase)entityLivingBase)) {
                entityLivingBase.func_70097_a(DAMAGESOURCE, damage);
                if (entityLivingBase.field_70128_L) {
                    iCropTile.setNutrientStorage(Math.min(100, iCropTile.getNutrientStorage() + (int)(10.0f * entityLivingBase.func_110138_aP())));
                    iCropTile.getWorld().func_72926_e(2005, iCropTile.getLocation().field_71574_a, iCropTile.getLocation().field_71572_b, iCropTile.getLocation().field_71573_c, 0);
                }
            }
        });
    }

    public static int[] array(int ... integers) {
        return integers;
    }

    public static int[] max(int max) {
        return HCropCardMirageCrops.range(1, max);
    }

    public static int[] min(CropCard cropCard, int min) {
        return HCropCardMirageCrops.range(min, cropCard.maxSize());
    }

    public static int[] range(int min, int max) {
        int[] tmp = new int[max - min + 1];
        for (int i = min; i <= max; ++i) {
            tmp[i - min] = i;
        }
        return tmp;
    }

    private static /* synthetic */ ItemStack lambda$5(int[] nArray, Function function, Function function2, ICropTile iCropTile) {
        if (HCropCardMirageCrops.contains(nArray, iCropTile.getSize())) {
            return (ItemStack)function.apply(iCropTile);
        }
        return (ItemStack)function2.apply(iCropTile);
    }
}

