/*
 * Decompiled with CFR 0.152.
 */
package mirrg.minecraft.nbt.mir60;

import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.nbt.NBTTagCompound;

public class HNbt {
    public static NbtType<Void> END = new NbtType(0, null);
    public static NbtType<Byte> BYTE = new NbtType(1, NBTTagCompound::func_74771_c);
    public static NbtType<Short> SHORT = new NbtType(2, NBTTagCompound::func_74765_d);
    public static NbtType<Integer> INT = new NbtType(3, NBTTagCompound::func_74762_e);
    public static NbtType<Long> LONG = new NbtType(4, NBTTagCompound::func_74763_f);
    public static NbtType<Float> FLOAT = new NbtType(5, NBTTagCompound::func_74760_g);
    public static NbtType<Double> DOUBLE = new NbtType(6, NBTTagCompound::func_74769_h);
    public static NbtType<byte[]> BYTE_ARRAY = new NbtType(7, NBTTagCompound::func_74770_j);
    public static NbtType<String> STRING = new NbtType(8, NBTTagCompound::func_74779_i);
    public static NbtType<Void> LIST = new NbtType(9, null);
    public static NbtType<NBTTagCompound> COMPOUND = new NbtType(10, NBTTagCompound::func_74775_l);
    public static NbtType<int[]> INT_ARRAY = new NbtType(11, NBTTagCompound::func_74759_k);

    public static <T> Optional<T> getItem(NBTTagCompound nbt, String path, NbtType<T> type) {
        if (nbt == null) {
            return Optional.empty();
        }
        String[] dirs = path.split("/");
        for (int i = 0; i < dirs.length - 1; ++i) {
            if (!nbt.func_150297_b(dirs[i], HNbt.COMPOUND.number)) {
                return Optional.empty();
            }
            nbt = nbt.func_74775_l(dirs[i]);
        }
        if (nbt.func_150297_b(dirs[dirs.length - 1], type.number)) {
            return Optional.of(type.getter.apply(nbt, dirs[dirs.length - 1]));
        }
        return Optional.empty();
    }

    public static Optional<Integer> getInteger(NBTTagCompound nbt, String path) {
        return HNbt.getItem(nbt, path, INT);
    }

    public static Optional<String> getString(NBTTagCompound nbt, String path) {
        return HNbt.getItem(nbt, path, STRING);
    }

    public static class NbtType<T> {
        public int number;
        public BiFunction<NBTTagCompound, String, T> getter;

        private NbtType(int number, BiFunction<NBTTagCompound, String, T> getter) {
            this.number = number;
            this.getter = getter;
        }
    }
}

